/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.Attribute;
import COSE.CoseException;
import COSE.HeaderKeys;
import COSE.KeyKeys;
import COSE.OneKey;
import COSE.SignCommon;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;

public class Signer
extends Attribute {
    protected byte[] rgbSignature;
    protected String contextString = "Signature";
    OneKey cnKey;

    public Signer() {
    }

    public Signer(OneKey key) {
        this.cnKey = key;
    }

    public void clearKey() {
        this.cnKey = null;
    }

    public void setKey(OneKey keyIn) throws CoseException {
        this.setupKey(keyIn);
    }

    private void setupKey(OneKey key) throws CoseException {
        CBORObject cn2;
        this.cnKey = key;
        if (this.rgbSignature != null) {
            return;
        }
        CBORObject cn = key.get(KeyKeys.Algorithm);
        if (cn != null && (cn2 = this.findAttribute(HeaderKeys.Algorithm)) == null) {
            this.addAttribute(HeaderKeys.Algorithm, cn, 1);
        }
        if ((cn = key.get(KeyKeys.KeyId)) != null && (cn2 = this.findAttribute(HeaderKeys.KID)) == null) {
            this.addAttribute(HeaderKeys.KID, cn, 2);
        }
    }

    protected void DecodeFromCBORObject(CBORObject obj) throws CoseException {
        if (obj.getType() != CBORType.Array) {
            throw new CoseException("Invalid Signer structure");
        }
        if (obj.size() != 3) {
            throw new CoseException("Invalid Signer structure");
        }
        if (obj.get(0).getType() == CBORType.ByteString) {
            this.rgbProtected = obj.get(0).GetByteString();
            if (this.rgbProtected.length == 0) {
                this.objProtected = CBORObject.NewMap();
            } else {
                this.objProtected = CBORObject.DecodeFromBytes((byte[])this.rgbProtected);
                if (this.objProtected.size() == 0) {
                    this.rgbProtected = new byte[0];
                }
            }
        } else {
            throw new CoseException("Invalid Signer structure");
        }
        if (obj.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid Signer structure");
        }
        this.objUnprotected = obj.get(1);
        if (obj.get(2).getType() == CBORType.ByteString) {
            this.rgbSignature = obj.get(2).GetByteString();
        } else if (!obj.get(2).isNull()) {
            throw new CoseException("Invalid Signer structure");
        }
    }

    protected CBORObject EncodeToCBORObject() throws CoseException {
        if (this.rgbSignature == null) {
            throw new CoseException("Message not yet signed");
        }
        if (this.rgbProtected == null) {
            throw new CoseException("Internal Error");
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.rgbProtected);
        obj.Add(this.objUnprotected);
        obj.Add((Object)this.rgbSignature);
        return obj;
    }

    public void sign(byte[] rgbBodyProtected, byte[] rgbContent) throws CoseException {
        if (this.rgbProtected == null) {
            this.rgbProtected = this.objProtected.size() == 0 ? new byte[0] : this.objProtected.EncodeToBytes();
        }
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.contextString);
        obj.Add((Object)rgbBodyProtected);
        obj.Add((Object)this.rgbProtected);
        obj.Add((Object)this.externalData);
        obj.Add((Object)rgbContent);
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        this.rgbSignature = SignCommon.computeSignature(alg, obj.EncodeToBytes(), this.cnKey);
    }

    public boolean validate(byte[] rgbBodyProtected, byte[] rgbContent) throws CoseException {
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.contextString);
        obj.Add((Object)rgbBodyProtected);
        obj.Add((Object)this.rgbProtected);
        obj.Add((Object)this.externalData);
        obj.Add((Object)rgbContent);
        AlgorithmID alg = AlgorithmID.FromCBOR(this.findAttribute(HeaderKeys.Algorithm));
        return SignCommon.validateSignature(alg, obj.EncodeToBytes(), this.rgbSignature, this.cnKey);
    }
}

