/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.Attribute;
import COSE.CoseException;
import COSE.Encrypt0Message;
import COSE.EncryptMessage;
import COSE.MAC0Message;
import COSE.MACMessage;
import COSE.MessageTag;
import COSE.Sign1Message;
import COSE.SignMessage;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.nio.charset.StandardCharsets;

public abstract class Message
extends Attribute {
    protected boolean emitTag = true;
    protected boolean emitContent = true;
    protected MessageTag messageTag = MessageTag.Unknown;
    protected byte[] rgbContent = null;

    public static Message DecodeFromBytes(byte[] rgbData) throws CoseException {
        return Message.DecodeFromBytes(rgbData, MessageTag.Unknown);
    }

    public static Message DecodeFromBytes(byte[] rgbData, MessageTag defaultTag) throws CoseException {
        Message msg;
        CBORObject messageObject = CBORObject.DecodeFromBytes((byte[])rgbData);
        if (messageObject.getType() != CBORType.Array) {
            throw new CoseException("Message is not a COSE security Message");
        }
        if (messageObject.isTagged()) {
            if (messageObject.GetTags().length != 1) {
                throw new CoseException("Malformed message - too many tags");
            }
            if (defaultTag == MessageTag.Unknown) {
                defaultTag = MessageTag.FromInt(messageObject.getInnermostTag().intValue());
            } else if (defaultTag != MessageTag.FromInt(messageObject.getInnermostTag().intValue())) {
                throw new CoseException("Passed in tag does not match actual tag");
            }
        }
        switch (defaultTag) {
            case Unknown: {
                throw new CoseException("Message was not tagged and no default tagging option given");
            }
            case Encrypt: {
                msg = new EncryptMessage();
                break;
            }
            case Encrypt0: {
                msg = new Encrypt0Message();
                break;
            }
            case MAC: {
                msg = new MACMessage();
                break;
            }
            case MAC0: {
                msg = new MAC0Message();
                break;
            }
            case Sign1: {
                msg = new Sign1Message();
                break;
            }
            case Sign: {
                msg = new SignMessage();
                break;
            }
            default: {
                throw new CoseException("Message is not recognized as a COSE security Object");
            }
        }
        msg.DecodeFromCBORObject(messageObject);
        return msg;
    }

    public byte[] EncodeToBytes() throws CoseException {
        return this.EncodeToCBORObject().EncodeToBytes();
    }

    protected abstract void DecodeFromCBORObject(CBORObject var1) throws CoseException;

    protected abstract CBORObject EncodeCBORObject() throws CoseException;

    public CBORObject EncodeToCBORObject() throws CoseException {
        CBORObject obj = this.EncodeCBORObject();
        if (this.emitTag) {
            obj = CBORObject.FromObjectAndTag((Object)obj, (int)this.messageTag.value);
        }
        return obj;
    }

    public byte[] GetContent() {
        return this.rgbContent;
    }

    public boolean HasContent() {
        return this.rgbContent != null;
    }

    public void SetContent(byte[] rgbData) {
        this.rgbContent = rgbData;
    }

    public void SetContent(String strData) {
        this.rgbContent = strData.getBytes(StandardCharsets.UTF_8);
    }
}

