/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.AlgorithmID;
import COSE.CoseException;
import COSE.HeaderKeys;
import COSE.Message;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.gcm.BasicGCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public abstract class EncryptCommon
extends Message {
    protected String context;
    protected byte[] rgbEncrypt;
    SecureRandom random = new SecureRandom();

    protected byte[] decryptWithKey(byte[] rgbKey) throws CoseException, InvalidCipherTextException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm.AsCBOR());
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        switch (alg) {
            case AES_GCM_128: 
            case AES_GCM_192: 
            case AES_GCM_256: {
                this.AES_GCM_Decrypt(alg, rgbKey);
                break;
            }
            case AES_CCM_16_64_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_64_64_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_128_256: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_128_256: {
                this.AES_CCM_Decrypt(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported Algorithm Specified");
            }
        }
        return this.rgbContent;
    }

    void encryptWithKey(byte[] rgbKey) throws CoseException, IllegalStateException, InvalidCipherTextException {
        CBORObject algX = this.findAttribute(HeaderKeys.Algorithm.AsCBOR());
        AlgorithmID alg = AlgorithmID.FromCBOR(algX);
        if (this.rgbContent == null) {
            throw new CoseException("No Content Specified");
        }
        switch (alg) {
            case AES_GCM_128: 
            case AES_GCM_192: 
            case AES_GCM_256: {
                if (rgbKey.length != alg.getKeySize() / 8) {
                    throw new CoseException("Incorrect Key Size");
                }
                this.AES_GCM_Encrypt(alg, rgbKey);
                break;
            }
            case AES_CCM_16_64_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_64_64_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_128_256: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_128_256: {
                if (rgbKey.length != alg.getKeySize() / 8) {
                    throw new CoseException("Incorrect Key Size");
                }
                this.AES_CCM_Encrypt(alg, rgbKey);
                break;
            }
            default: {
                throw new CoseException("Unsupported Algorithm Specified");
            }
        }
    }

    private void AES_CCM_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException, InvalidCipherTextException {
        CCMBlockCipher cipher = new CCMBlockCipher((BlockCipher)new AESFastEngine());
        int cbIV = 0;
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_128_256: {
                cbIV = 13;
                break;
            }
            case AES_CCM_64_64_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_128_256: {
                cbIV = 7;
            }
        }
        CBORObject cn = this.findAttribute(HeaderKeys.IV);
        if (cn == null) {
            throw new CoseException("Missing IV during decryption");
        }
        if (cn.getType() != CBORType.ByteString) {
            throw new CoseException("IV is incorrectly formed");
        }
        if (cn.GetByteString().length != cbIV) {
            throw new CoseException("IV size is incorrect");
        }
        byte[] IV = cn.GetByteString();
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Missing IV during decryption");
        }
        KeyParameter ContentKey = new KeyParameter(rgbKey);
        AEADParameters parameters = new AEADParameters(ContentKey, alg.getTagSize(), IV, this.getAADBytes());
        cipher.init(false, (CipherParameters)parameters);
        byte[] C = new byte[cipher.getOutputSize(this.rgbEncrypt.length)];
        int len = cipher.processBytes(this.rgbEncrypt, 0, this.rgbEncrypt.length, C, 0);
        len += cipher.doFinal(C, len);
        this.rgbContent = C;
    }

    private void AES_CCM_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException, InvalidCipherTextException {
        int cbIV;
        CCMBlockCipher cipher = new CCMBlockCipher((BlockCipher)new AESFastEngine());
        switch (alg) {
            case AES_CCM_16_64_128: 
            case AES_CCM_16_64_256: 
            case AES_CCM_16_128_128: 
            case AES_CCM_16_128_256: {
                cbIV = 13;
                break;
            }
            case AES_CCM_64_64_128: 
            case AES_CCM_64_64_256: 
            case AES_CCM_64_128_128: 
            case AES_CCM_64_128_256: {
                cbIV = 7;
                break;
            }
            default: {
                throw new CoseException("Unsupported algorithm: " + (Object)((Object)alg));
            }
        }
        byte[] IV = new byte[cbIV];
        CBORObject cbor = this.findAttribute(HeaderKeys.IV);
        if (cbor != null) {
            if (cbor.getType() != CBORType.ByteString) {
                throw new CoseException("IV is incorreclty formed.");
            }
            if (cbor.GetByteString().length > cbIV) {
                throw new CoseException("IV is too long.");
            }
            IV = cbor.GetByteString();
        } else {
            this.random.nextBytes(IV);
            this.AddUnprotected(HeaderKeys.IV, CBORObject.FromObject((byte[])IV));
        }
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        KeyParameter ContentKey = new KeyParameter(rgbKey);
        AEADParameters parameters = new AEADParameters(ContentKey, alg.getTagSize(), IV, this.getAADBytes());
        cipher.init(true, (CipherParameters)parameters);
        byte[] C = new byte[cipher.getOutputSize(this.rgbContent.length)];
        int len = cipher.processBytes(this.rgbContent, 0, this.rgbContent.length, C, 0);
        len += cipher.doFinal(C, len);
        this.rgbEncrypt = C;
    }

    private void AES_GCM_Decrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, InvalidCipherTextException {
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESFastEngine(), (GCMMultiplier)new BasicGCMMultiplier());
        CBORObject cn = this.findAttribute(HeaderKeys.IV);
        if (cn == null) {
            throw new CoseException("Missing IV during decryption");
        }
        if (cn.getType() != CBORType.ByteString) {
            throw new CoseException("IV is incorrectly formed");
        }
        if (cn.GetByteString().length != 12) {
            throw new CoseException("IV size is incorrect");
        }
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Missing IV during decryption");
        }
        KeyParameter contentKey = new KeyParameter(rgbKey);
        AEADParameters parameters = new AEADParameters(contentKey, 128, cn.GetByteString(), this.getAADBytes());
        cipher.init(false, (CipherParameters)parameters);
        byte[] C = new byte[cipher.getOutputSize(this.rgbEncrypt.length)];
        int length = cipher.processBytes(this.rgbEncrypt, 0, this.rgbEncrypt.length, C, 0);
        length += cipher.doFinal(C, length);
        this.rgbContent = C;
    }

    private void AES_GCM_Encrypt(AlgorithmID alg, byte[] rgbKey) throws CoseException, IllegalStateException, InvalidCipherTextException {
        byte[] IV;
        GCMBlockCipher cipher = new GCMBlockCipher((BlockCipher)new AESFastEngine(), (GCMMultiplier)new BasicGCMMultiplier());
        if (rgbKey.length != alg.getKeySize() / 8) {
            throw new CoseException("Key Size is incorrect");
        }
        KeyParameter contentKey = new KeyParameter(rgbKey);
        CBORObject cn = this.findAttribute(HeaderKeys.IV);
        if (cn == null) {
            IV = new byte[12];
            this.random.nextBytes(IV);
            this.AddUnprotected(HeaderKeys.IV, CBORObject.FromObject((byte[])IV));
        } else {
            if (cn.getType() != CBORType.ByteString) {
                throw new CoseException("IV is incorrectly formed");
            }
            if (cn.GetByteString().length != 12) {
                throw new CoseException("IV size is incorrect");
            }
            IV = cn.GetByteString();
        }
        AEADParameters parameters = new AEADParameters(contentKey, 128, IV, this.getAADBytes());
        cipher.init(true, (CipherParameters)parameters);
        byte[] C = new byte[cipher.getOutputSize(this.rgbContent.length)];
        int length = cipher.processBytes(this.rgbContent, 0, this.rgbContent.length, C, 0);
        length += cipher.doFinal(C, length);
        this.rgbEncrypt = C;
    }

    private byte[] getAADBytes() {
        CBORObject obj = CBORObject.NewArray();
        obj.Add((Object)this.context);
        if (this.objProtected.size() == 0) {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        } else {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        }
        obj.Add(CBORObject.FromObject((byte[])this.externalData));
        return obj.EncodeToBytes();
    }

    public byte[] getEncryptedContent() throws CoseException {
        if (this.rgbEncrypt == null) {
            throw new CoseException("No Encrypted Content Specified");
        }
        return this.rgbEncrypt;
    }

    public void setEncryptedContent(byte[] rgb) {
        this.rgbEncrypt = rgb;
    }
}

