/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.HeaderKeys;
import com.upokecenter.cbor.CBORObject;

public class Attribute {
    protected CBORObject objProtected = CBORObject.NewMap();
    protected CBORObject objUnprotected = CBORObject.NewMap();
    protected CBORObject objDontSend = CBORObject.NewMap();
    protected byte[] rgbProtected;
    protected byte[] externalData = new byte[0];
    public static final int ProtectedAttributes = 1;
    public static final int UnprotectedAttributes = 2;
    public static final int DontSendAttributes = 4;

    public void addAttribute(CBORObject label, CBORObject value, int where) {
        this.RemoveAttribute(label);
        switch (where) {
            case 1: {
                this.objProtected.Add((Object)label, (Object)value);
                break;
            }
            case 2: {
                this.objUnprotected.Add((Object)label, (Object)value);
                break;
            }
            case 4: {
                this.objDontSend.Add((Object)label, (Object)value);
            }
        }
    }

    public void addAttribute(HeaderKeys label, CBORObject value, int where) {
        this.addAttribute(label.AsCBOR(), value, where);
    }

    public void addAttribute(HeaderKeys label, byte[] value, int where) {
        this.addAttribute(label.AsCBOR(), CBORObject.FromObject((byte[])value), where);
    }

    @Deprecated
    public void AddProtected(CBORObject label, CBORObject value) {
        this.RemoveAttribute(label);
        this.objProtected.Add((Object)label, (Object)value);
    }

    @Deprecated
    public void AddProtected(HeaderKeys label, CBORObject value) {
        this.AddProtected(label.AsCBOR(), value);
    }

    @Deprecated
    public void AddProtected(HeaderKeys label, byte[] value) {
        this.AddProtected(label, CBORObject.FromObject((byte[])value));
    }

    public void AddUnprotected(CBORObject label, CBORObject value) {
        this.RemoveAttribute(label);
        this.objUnprotected.Add((Object)label, (Object)value);
    }

    public void AddUnprotected(HeaderKeys label, CBORObject value) {
        this.AddUnprotected(label.AsCBOR(), value);
    }

    public void AddUnprotected(HeaderKeys label, byte[] value) {
        this.AddUnprotected(label, CBORObject.FromObject((byte[])value));
    }

    public CBORObject findAttribute(CBORObject label) {
        if (this.objProtected.ContainsKey(label)) {
            return this.objProtected.get(label);
        }
        if (this.objUnprotected.ContainsKey(label)) {
            return this.objUnprotected.get(label);
        }
        if (this.objDontSend.ContainsKey(label)) {
            return this.objDontSend.get(label);
        }
        return null;
    }

    public CBORObject findAttribute(HeaderKeys key) {
        return this.findAttribute(key.AsCBOR());
    }

    private void RemoveAttribute(CBORObject label) {
        if (this.objProtected.ContainsKey(label)) {
            this.objProtected.Remove(label);
        }
        if (this.objUnprotected.ContainsKey(label)) {
            this.objUnprotected.Remove(label);
        }
        if (this.objDontSend.ContainsKey(label)) {
            this.objDontSend.Remove(label);
        }
    }

    public void setExternal(byte[] rgbData) {
        if (rgbData == null) {
            rgbData = new byte[]{};
        }
        this.externalData = rgbData;
    }
}

