/*
 * Decompiled with CFR 0.152.
 */
package com.att.ajsc.common.exception;

import com.att.ajsc.common.error.StatusResponse;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public abstract class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected List<StatusResponse> statuses = new ArrayList<StatusResponse>();

    public ServiceException(int code) {
        this(code, null);
    }

    public ServiceException(int code, String message) {
        this(code, message, null);
    }

    public ServiceException(int code, String message, String requestBody) {
        super(message);
        StatusResponse status = new StatusResponse();
        status.setCode(code);
        status.setMessage(message);
        status.setRequestBody(requestBody);
        this.statuses.add(status);
    }

    public void addStatus(StatusResponse status) {
        this.statuses.add(status);
    }

    public int getOverallStatusCode() {
        int highestCode = 0;
        for (StatusResponse status : this.statuses) {
            if (status.getCode() <= highestCode) continue;
            highestCode = status.getCode();
        }
        return highestCode;
    }

    public Response toResponse() {
        int overallStatusCode = this.getOverallStatusCode();
        Response response = Response.status((int)overallStatusCode).entity(this.statuses).type("application/json").build();
        return response;
    }

    public WebApplicationException getRestException() {
        return new WebApplicationException(this.toResponse());
    }

    @Override
    public String toString() {
        return this.statuses.toString();
    }
}

