/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence.imp;

import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMPreEnterListener;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.ObjectImage;
import com.atomikos.persistence.ObjectLog;
import com.atomikos.persistence.StateRecoverable;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.persistence.imp.StateObjectImage;
import java.util.Enumeration;
import java.util.Vector;

public class StateRecoveryManagerImp
implements StateRecoveryManager,
FSMPreEnterListener {
    protected ObjectLog objectlog_;

    public StateRecoveryManagerImp(ObjectLog objectLog) {
        this.objectlog_ = objectLog;
    }

    public void init() throws LogException {
        this.objectlog_.init();
    }

    public void register(StateRecoverable stateRecoverable) {
        if (stateRecoverable == null) {
            throw new IllegalArgumentException("null in register arg");
        }
        Object[] objectArray = stateRecoverable.getRecoverableStates();
        if (objectArray != null) {
            int n;
            for (n = 0; n < objectArray.length; ++n) {
                stateRecoverable.addFSMPreEnterListener(this, objectArray[n]);
            }
            objectArray = stateRecoverable.getFinalStates();
            for (n = 0; n < objectArray.length; ++n) {
                stateRecoverable.addFSMPreEnterListener(this, objectArray[n]);
            }
        }
    }

    public void preEnter(FSMEnterEvent fSMEnterEvent) throws IllegalStateException {
        Object object = fSMEnterEvent.getState();
        StateRecoverable stateRecoverable = (StateRecoverable)fSMEnterEvent.getSource();
        ObjectImage objectImage = stateRecoverable.getObjectImage(object);
        if (objectImage != null) {
            StateObjectImage stateObjectImage = new StateObjectImage(objectImage);
            Object[] objectArray = stateRecoverable.getFinalStates();
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!object.equals(objectArray[i])) continue;
                bl = true;
            }
            try {
                if (!bl) {
                    this.objectlog_.flush(stateObjectImage);
                } else {
                    this.objectlog_.delete(stateObjectImage.getId());
                }
            }
            catch (LogException logException) {
                throw new IllegalStateException("could not flush state image " + logException.getMessage() + " " + logException.getClass().getName());
            }
        }
    }

    public void close() throws LogException {
        this.objectlog_.close();
    }

    public StateRecoverable recover(Object object) throws LogException {
        StateRecoverable stateRecoverable = (StateRecoverable)this.objectlog_.recover(object);
        if (stateRecoverable != null) {
            this.register(stateRecoverable);
        }
        return stateRecoverable;
    }

    public Vector recover() throws LogException {
        Vector vector = this.objectlog_.recover();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            StateRecoverable stateRecoverable = (StateRecoverable)enumeration.nextElement();
            this.register(stateRecoverable);
        }
        return vector;
    }

    public void delete(Object object) throws LogException {
        this.objectlog_.delete(object);
    }
}

