/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp.thread;

import com.atomikos.icatch.system.Configuration;

final class ThreadFactory {
    static final ThreadFactory singleton = new ThreadFactory("Atomikos");
    private final String name;
    private int count;
    private final ThreadGroup group;

    static ThreadFactory getInstance() {
        return singleton;
    }

    private ThreadFactory(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.name = string;
    }

    String getBaseName() {
        return this.name;
    }

    Thread newThread(Runnable runnable) {
        String string = this.name + ":" + this.incCount();
        Configuration.logDebug("ThreadFactory: creating new thread: " + string);
        Thread thread = new Thread(this.group, runnable, string);
        thread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        thread.setDaemon(true);
        return thread;
    }

    private synchronized int incCount() {
        return this.count++;
    }
}

