/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.StringHeuristicMessage;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.RollbackOnlyParticipant;
import com.atomikos.icatch.imp.SubTransactionCoordinatorParticipant;
import com.atomikos.icatch.imp.TxRollbackOnlyStateHandler;
import com.atomikos.icatch.imp.TxTerminatedStateHandler;
import com.atomikos.icatch.imp.TxTerminatingStateHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;

abstract class TransactionStateHandler
implements SubTxAwareParticipant {
    private int subtxs_;
    private Stack synchronizations_;
    private List subtxawares_;
    private CompositeTransactionImp ct_;

    protected TransactionStateHandler(CompositeTransactionImp compositeTransactionImp) {
        this.ct_ = compositeTransactionImp;
        this.subtxs_ = 0;
        this.subtxawares_ = new ArrayList();
        this.synchronizations_ = new Stack();
    }

    protected TransactionStateHandler(CompositeTransactionImp compositeTransactionImp, TransactionStateHandler transactionStateHandler) {
        this.subtxs_ = transactionStateHandler.getSubTransactionCount();
        this.synchronizations_ = transactionStateHandler.getSynchronizations();
        this.subtxawares_ = transactionStateHandler.getSubtxawares();
        this.ct_ = compositeTransactionImp;
    }

    private synchronized void localDecSubTxCount() {
        --this.subtxs_;
    }

    private synchronized void localIncSubTxCount() {
        ++this.subtxs_;
    }

    private synchronized int localGetSubTxCount() {
        return this.subtxs_;
    }

    private synchronized void localPushSynchronization(Synchronization synchronization) {
        this.synchronizations_.push(synchronization);
    }

    private synchronized void localAddSubTxAwareParticipant(SubTxAwareParticipant subTxAwareParticipant) {
        this.subtxawares_.add(subTxAwareParticipant);
    }

    protected CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        CompositeTransaction compositeTransaction = null;
        compositeTransaction = this.ct_.getTransactionService().createSubTransaction(this.ct_);
        compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        this.localIncSubTxCount();
        return compositeTransaction;
    }

    protected RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        CoordinatorImp coordinatorImp = this.ct_.getCoordinatorImp();
        try {
            coordinatorImp.addParticipant(participant);
        }
        catch (RollbackException rollbackException) {
            throw new IllegalStateException("Transaction already rolled back");
        }
        return coordinatorImp;
    }

    protected void registerSynchronization(Synchronization synchronization) throws IllegalStateException, UnsupportedOperationException, SysException {
        if (synchronization != null) {
            try {
                this.ct_.getCoordinatorImp().registerSynchronization(synchronization);
            }
            catch (RollbackException rollbackException) {
                throw new IllegalStateException("Transaction already rolled back");
            }
            this.localPushSynchronization(synchronization);
        }
    }

    protected void addSubTxAwareParticipant(SubTxAwareParticipant subTxAwareParticipant) throws SysException, IllegalStateException {
        this.localAddSubTxAwareParticipant(subTxAwareParticipant);
    }

    private void rollback() throws IllegalStateException, SysException {
        SubTxAwareParticipant subTxAwareParticipant;
        Stack<Throwable> stack = new Stack<Throwable>();
        for (int i = 0; i < this.subtxawares_.size(); ++i) {
            subTxAwareParticipant = (SubTxAwareParticipant)this.subtxawares_.get(i);
            subTxAwareParticipant.rolledback((CompositeTransaction)this.ct_);
        }
        Enumeration enumeration = null;
        subTxAwareParticipant = this.ct_.getExtent();
        if (subTxAwareParticipant != null) {
            enumeration = subTxAwareParticipant.getParticipants().elements();
            while (enumeration.hasMoreElements()) {
                Participant participant = (Participant)enumeration.nextElement();
                this.addParticipant(participant);
            }
        }
        this.ct_.localSetTransactionStateHandler(new TxTerminatedStateHandler(this.ct_, this, false));
        try {
            this.ct_.getCoordinatorImp().rollback();
        }
        catch (HeurCommitException heurCommitException) {
            stack.push(heurCommitException);
            throw new SysException("Unexpected error in rollback", stack);
        }
        catch (HeurMixedException heurMixedException) {
            stack.push(heurMixedException);
            throw new SysException("Unexpected error in rollback", stack);
        }
        catch (HeurHazardException heurHazardException) {
            stack.push(heurHazardException);
            throw new SysException("Unexpected error in rollback", stack);
        }
    }

    protected void rollbackWithStateCheck() throws IllegalStateException, SysException {
        this.ct_.localTestAndSetTransactionStateHandler(this, new TxTerminatingStateHandler(false, this.ct_, this));
        this.rollback();
    }

    protected void commit() throws SysException, IllegalStateException, RollbackException {
        Participant participant;
        Synchronization synchronization;
        Object var1_1 = null;
        Object var2_2 = null;
        this.ct_.localTestAndSetTransactionStateHandler(this, new TxTerminatingStateHandler(true, this.ct_, this));
        if (this.ct_.isLocalRoot()) {
            this.ct_.getCoordinatorImp().addTag(this.ct_.tag_);
            synchronization = this.ct_.getExtent().getParticipants().elements();
            while (synchronization.hasMoreElements()) {
                participant = (Participant)synchronization.nextElement();
                this.addParticipant(participant);
            }
        }
        if (this.subtxs_ > 0) {
            throw new IllegalStateException("active subtransactions exist");
        }
        synchronization = null;
        participant = this.synchronizations_.elements();
        while (participant.hasMoreElements()) {
            synchronization = (Synchronization)participant.nextElement();
            synchronization.beforeCompletion();
        }
        if (this.ct_.getState().equals(TxState.MARKED_ABORT)) {
            this.rollback();
            throw new RollbackException("The transaction was set to rollback only");
        }
        for (int i = 0; i < this.subtxawares_.size(); ++i) {
            SubTxAwareParticipant subTxAwareParticipant = (SubTxAwareParticipant)this.subtxawares_.get(i);
            subTxAwareParticipant.committed((CompositeTransaction)this.ct_);
        }
        this.ct_.localSetTransactionStateHandler(new TxTerminatedStateHandler(this.ct_, this, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRollbackOnly() {
        StringHeuristicMessage stringHeuristicMessage = new StringHeuristicMessage("Transaction.setRollbackOnly was called.");
        RollbackOnlyParticipant rollbackOnlyParticipant = new RollbackOnlyParticipant(stringHeuristicMessage);
        this.addParticipant(rollbackOnlyParticipant);
        TransactionStateHandler transactionStateHandler = this;
        synchronized (transactionStateHandler) {
            this.ct_.localSetTransactionStateHandler(new TxRollbackOnlyStateHandler(this.ct_, this));
        }
    }

    public void committed(CompositeTransaction compositeTransaction) {
        CompositeTransactionImp compositeTransactionImp = (CompositeTransactionImp)compositeTransaction;
        Extent extent = compositeTransaction.getTransactionControl().getExtent();
        Extent extent2 = this.ct_.getExtent();
        extent2.add(extent);
        SubTransactionCoordinatorParticipant subTransactionCoordinatorParticipant = new SubTransactionCoordinatorParticipant(compositeTransactionImp.getCoordinatorImp());
        this.addParticipant(subTransactionCoordinatorParticipant);
        this.localDecSubTxCount();
    }

    public void rolledback(CompositeTransaction compositeTransaction) {
        this.localDecSubTxCount();
    }

    protected abstract Object getState();

    protected List getSubtxawares() {
        return this.subtxawares_;
    }

    protected CompositeTransactionImp getCT() {
        return this.ct_;
    }

    protected int getSubTransactionCount() {
        return this.localGetSubTxCount();
    }

    protected Stack getSynchronizations() {
        return this.synchronizations_;
    }

    protected void addSynchronizations(Stack stack) {
        while (!stack.empty()) {
            Synchronization synchronization = (Synchronization)stack.pop();
            this.localPushSynchronization(synchronization);
        }
    }
}

