/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.diagnostics.Console;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TSListener;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.LogControlImp;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.persistence.LogException;
import com.atomikos.persistence.StateRecoveryManager;
import com.atomikos.util.UniqueIdMgr;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public class TransactionServiceImp
implements TransactionService,
FSMEnterListener,
SubTxAwareParticipant,
RecoveryService {
    private static final int NUMLATCHES = 97;
    private long maxTimeout_;
    private Object[] rootlatches_ = null;
    private Hashtable tidtotxmap_ = null;
    private Hashtable roottocoordinatormap_ = null;
    private boolean shuttingDown_ = false;
    private Object shutdownWaiter_;
    private Object recoveryWaiter_;
    private UniqueIdMgr tidmgr_ = null;
    private StateRecoveryManager recoverymanager_ = null;
    private boolean initialized_ = false;
    private Console console_;
    private LogControl control_;
    private boolean otsOverride_;
    private Vector listeners_;
    private int maxActives_;
    private String name_;
    private Properties properties_;
    private boolean single_threaded_2pc_;

    public TransactionServiceImp(String string, StateRecoveryManager stateRecoveryManager, UniqueIdMgr uniqueIdMgr, Console console, long l, int n, boolean bl) {
        this(string, stateRecoveryManager, uniqueIdMgr, console, l, true, n, bl);
    }

    public TransactionServiceImp(String string, StateRecoveryManager stateRecoveryManager, UniqueIdMgr uniqueIdMgr, Console console, long l, boolean bl, int n, boolean bl2) {
        this.maxActives_ = n;
        this.otsOverride_ = !bl;
        this.initialized_ = false;
        this.recoverymanager_ = stateRecoveryManager;
        this.tidmgr_ = uniqueIdMgr;
        this.tidtotxmap_ = new Hashtable();
        this.shutdownWaiter_ = new Object();
        this.recoveryWaiter_ = new Object();
        this.roottocoordinatormap_ = new Hashtable();
        this.rootlatches_ = new Object[97];
        for (int i = 0; i < 97; ++i) {
            this.rootlatches_[i] = new Object();
        }
        this.console_ = console;
        this.maxTimeout_ = l;
        this.name_ = string;
        this.listeners_ = new Vector();
        this.single_threaded_2pc_ = bl2;
    }

    protected Object getLatch(String string) {
        return this.rootlatches_[Math.abs(string.toString().hashCode() % 97)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTidToTx(String string, CompositeTransaction compositeTransaction) throws IllegalStateException {
        Hashtable hashtable = this.tidtotxmap_;
        synchronized (hashtable) {
            if (this.tidtotxmap_.containsKey(string.intern())) {
                throw new IllegalStateException("Already mapped: " + string);
            }
            this.tidtotxmap_.put(string.intern(), compositeTransaction);
            compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        }
    }

    Vector getCoordinatorImpVector() {
        Vector<CoordinatorImp> vector = new Vector<CoordinatorImp>();
        Enumeration enumeration = this.roottocoordinatormap_.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            CoordinatorImp coordinatorImp = this.getCoordinatorImp(string);
            if (coordinatorImp == null) continue;
            vector.addElement(coordinatorImp);
        }
        return vector;
    }

    private void notifyListeners(boolean bl, boolean bl2) {
        Enumeration enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            TSListener tSListener = (TSListener)enumeration.nextElement();
            try {
                if (bl) {
                    tSListener.init(bl2, this.properties_);
                    continue;
                }
                tSListener.shutdown(bl2);
            }
            catch (Exception exception) {
                Configuration.logWarning("Error in TSListener", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCoordinator(CompositeCoordinator compositeCoordinator) {
        Object object = this.shutdownWaiter_;
        synchronized (object) {
            Object object2 = this.getLatch(compositeCoordinator.getCoordinatorId().intern());
            synchronized (object2) {
                this.roottocoordinatormap_.remove(compositeCoordinator.getCoordinatorId().intern());
            }
            if (this.roottocoordinatormap_.isEmpty()) {
                this.shutdownWaiter_.notifyAll();
            }
        }
    }

    private void removeTransaction(CompositeTransaction compositeTransaction) {
        if (compositeTransaction == null) {
            return;
        }
        this.tidtotxmap_.remove(compositeTransaction.getTid().intern());
    }

    private CompositeTransactionImp createCT(String string, CoordinatorImp coordinatorImp, Stack stack, boolean bl) throws SysException {
        Configuration.logDebug("Creating composite transaction: " + string);
        CompositeTransactionImp compositeTransactionImp = new CompositeTransactionImp(this, stack, string, bl, coordinatorImp);
        this.setTidToTx(compositeTransactionImp.getTid(), compositeTransactionImp);
        return compositeTransactionImp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp createCC(RecoveryCoordinator recoveryCoordinator, String string, boolean bl, boolean bl2, long l) {
        CoordinatorImp coordinatorImp = null;
        if (l > this.maxTimeout_) {
            l = this.maxTimeout_;
            Configuration.logWarning("Attempt to create a transaction with a timeout that exceeds com.atomikos.icatch.max_timeout - truncating to: " + this.maxTimeout_);
        }
        Object object = this.shutdownWaiter_;
        synchronized (object) {
            if (this.shuttingDown_) {
                throw new IllegalStateException("Server is shutting down...");
            }
            if (this.otsOverride_) {
                bl = false;
            }
            coordinatorImp = new CoordinatorImp(string, recoveryCoordinator, this.console_, bl2, l, bl, this.single_threaded_2pc_);
            this.recoverymanager_.register(coordinatorImp);
            Object object2 = this.getLatch(string.intern());
            synchronized (object2) {
                this.roottocoordinatormap_.put(string.intern(), coordinatorImp);
            }
            this.startlistening(coordinatorImp);
        }
        return coordinatorImp;
    }

    private void startlistening(CoordinatorImp coordinatorImp) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        hashtable.put(TxState.TERMINATED, new Object());
        Object[] objectArray = coordinatorImp.getFinalStates();
        for (int i = 0; i < objectArray.length; ++i) {
            hashtable.put(objectArray[i], new Object());
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            coordinatorImp.addFSMEnterListener(this, k);
        }
        if (hashtable.contains(coordinatorImp.getState())) {
            this.removeCoordinator(coordinatorImp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinatorImp getCoordinatorImp(String string) throws SysException {
        string = string.intern();
        Stack<LogException> stack = new Stack<LogException>();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CoordinatorImp coordinatorImp = null;
        Object object = this.shutdownWaiter_;
        synchronized (object) {
            Object object2 = this.getLatch(string);
            synchronized (object2) {
                coordinatorImp = (CoordinatorImp)this.roottocoordinatormap_.get(string.intern());
                if (coordinatorImp == null) {
                    try {
                        coordinatorImp = (CoordinatorImp)this.recoverymanager_.recover(string);
                    }
                    catch (LogException logException) {
                        stack.push(logException);
                        throw new SysException("Error in getting coordinator: " + logException.getMessage(), stack);
                    }
                    if (coordinatorImp != null) {
                        this.startlistening(coordinatorImp);
                        this.roottocoordinatormap_.put(string.intern(), coordinatorImp);
                    }
                }
            }
        }
        return coordinatorImp;
    }

    protected String createTid() throws SysException {
        return this.tidmgr_.get();
    }

    protected StateRecoveryManager getStateRecoveryManager() {
        return this.recoverymanager_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void recoverCoordinators() throws SysException {
        Stack<Exception> stack = new Stack<Exception>();
        try {
            Vector vector = this.recoverymanager_.recover();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CoordinatorImp coordinatorImp = (CoordinatorImp)enumeration.nextElement();
                Object object = this.getLatch(coordinatorImp.getCoordinatorId().intern());
                synchronized (object) {
                    this.roottocoordinatormap_.put(coordinatorImp.getCoordinatorId().intern(), coordinatorImp);
                }
                this.startlistening(coordinatorImp);
            }
        }
        catch (Exception exception) {
            Configuration.logWarning("Error in recoverCoordinators", exception);
            stack.push(exception);
            throw new SysException("Error in recoverCoordinators: " + exception.getMessage(), stack);
        }
    }

    public String getName() {
        return this.name_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        if (Configuration.getTransactionService() == null) {
            Configuration.installTransactionService(this);
            Configuration.installRecoveryService(this);
        }
        if (!this.initialized_) {
            this.notifyListeners(true, true);
            this.initialized_ = true;
        }
        Object object = this.recoveryWaiter_;
        synchronized (object) {
            try {
                Object object2;
                Vector vector = this.getCoordinatorImpVector();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    object2 = (CoordinatorImp)iterator.next();
                    try {
                        if (((CoordinatorImp)object2).recover() || this.console_ == null) continue;
                        this.console_.println("Coordinator not recoverable: " + ((CoordinatorImp)object2).getCoordinatorId());
                    }
                    catch (Exception exception) {
                        Configuration.logWarning("Coordinator not recoverable: " + ((CoordinatorImp)object2).getCoordinatorId(), exception);
                    }
                }
                object2 = Configuration.getResources();
                while (object2.hasMoreElements()) {
                    RecoverableResource recoverableResource = (RecoverableResource)object2.nextElement();
                    try {
                        recoverableResource.endRecovery();
                    }
                    catch (Exception exception) {
                        Configuration.logWarning("ERROR IN RECOVERY", exception);
                    }
                }
            }
            catch (Exception exception) {
                Configuration.logWarning("Error in recover: " + exception.getClass().getName() + exception.getMessage(), exception);
                Stack<Exception> stack = new Stack<Exception>();
                stack.push(exception);
                throw new SysException("Error in recovering: " + exception.getMessage(), stack);
            }
        }
    }

    public LogControl getLogControl() {
        return this.control_;
    }

    public CompositeCoordinator getCompositeCoordinator(String string) throws SysException {
        return this.getCoordinatorImp(string);
    }

    public void addTSListener(TSListener tSListener) throws IllegalStateException {
        if (!this.listeners_.contains(tSListener)) {
            this.listeners_.addElement(tSListener);
            if (this.initialized_) {
                tSListener.init(false, this.properties_);
            }
            Configuration.logDebug("Added TSListener: " + tSListener);
        }
    }

    public void removeTSListener(TSListener tSListener) {
        this.listeners_.removeElement(tSListener);
        Configuration.logDebug("Removed TSListener: " + tSListener);
    }

    public synchronized void init(Properties properties) throws SysException {
        Stack<LogException> stack = new Stack<LogException>();
        this.properties_ = properties;
        try {
            this.recoverymanager_.init();
        }
        catch (LogException logException) {
            stack.push(logException);
            throw new SysException("Error in init: " + logException.getMessage(), stack);
        }
        this.recoverCoordinators();
        this.shuttingDown_ = false;
        this.control_ = new LogControlImp(this);
        this.recover();
        this.notifyListeners(true, false);
    }

    public Participant getParticipant(String string) throws SysException {
        return this.getCoordinatorImp(string);
    }

    public void entered(FSMEnterEvent fSMEnterEvent) {
        CoordinatorImp coordinatorImp = (CoordinatorImp)fSMEnterEvent.getSource();
        Object object = fSMEnterEvent.getState();
        this.removeCoordinator(coordinatorImp);
    }

    public void committed(CompositeTransaction compositeTransaction) {
        this.removeTransaction(compositeTransaction);
    }

    public void rolledback(CompositeTransaction compositeTransaction) {
        this.removeTransaction(compositeTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeTransaction getCompositeTransaction(String string) {
        CompositeTransaction compositeTransaction = null;
        Hashtable hashtable = this.tidtotxmap_;
        synchronized (hashtable) {
            compositeTransaction = (CompositeTransaction)this.tidtotxmap_.get(string.intern());
        }
        return compositeTransaction;
    }

    CompositeTransaction createSubTransaction(CompositeTransaction compositeTransaction) {
        CompositeTransactionImp compositeTransactionImp = null;
        Stack stack = (Stack)compositeTransaction.getLineage().clone();
        stack.push(compositeTransaction);
        String string = this.tidmgr_.get();
        CoordinatorImp coordinatorImp = (CoordinatorImp)compositeTransaction.getCompositeCoordinator();
        CoordinatorImp coordinatorImp2 = this.createCC(null, string, false, coordinatorImp.prefersHeuristicCommit(), compositeTransaction.getTimeout());
        if (coordinatorImp.isRecoverableWhileActive() != null && coordinatorImp.isRecoverableWhileActive().booleanValue()) {
            coordinatorImp2.setRecoverableWhileActive();
        }
        compositeTransactionImp = this.createCT(string, coordinatorImp2, stack, compositeTransaction.isSerial());
        compositeTransactionImp.localRoot_ = false;
        return compositeTransactionImp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompositeTransaction recreateCompositeTransaction(Propagation propagation, boolean bl, boolean bl2) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.maxActives_ >= 0 && this.tidtotxmap_.size() >= this.maxActives_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxActives_);
        }
        Stack<Exception> stack = new Stack<Exception>();
        CoordinatorImp coordinatorImp = null;
        CompositeTransactionImp compositeTransactionImp = null;
        try {
            String string = this.tidmgr_.get();
            boolean bl3 = propagation.isSerial();
            Stack stack2 = propagation.getLineage();
            if (stack2.empty()) {
                throw new SysException("Empty lineage in propagation: empty lineage");
            }
            Stack stack3 = new Stack();
            while (!stack2.empty()) {
                stack3.push(stack2.pop());
            }
            CompositeTransaction compositeTransaction = (CompositeTransaction)stack3.peek();
            while (!stack3.empty()) {
                stack2.push(stack3.pop());
            }
            CompositeTransaction compositeTransaction2 = (CompositeTransaction)stack2.peek();
            Object object = this.shutdownWaiter_;
            synchronized (object) {
                Object object2 = this.getLatch(compositeTransaction.getTid());
                synchronized (object2) {
                    coordinatorImp = this.getCoordinatorImp(compositeTransaction.getTid());
                    if (coordinatorImp == null) {
                        RecoveryCoordinator recoveryCoordinator = compositeTransaction2.getCompositeCoordinator().getRecoveryCoordinator();
                        coordinatorImp = this.createCC(recoveryCoordinator, compositeTransaction.getTid(), bl, bl2, propagation.getTimeOut());
                    }
                    coordinatorImp.incLocalSiblingCount();
                }
            }
            compositeTransactionImp = this.createCT(string, coordinatorImp, stack2, bl3);
        }
        catch (Exception exception) {
            stack.push(exception);
            exception.printStackTrace();
            throw new SysException("Error in recreate.", stack);
        }
        return compositeTransactionImp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean bl) throws SysException, IllegalStateException {
        Object object;
        Object object2;
        Enumeration enumeration;
        Stack<Exception> stack = new Stack<Exception>();
        boolean bl2 = false;
        Configuration.logDebug("Transaction Service: Entering shutdown ( " + bl + " )...");
        if (!bl2 && bl) {
            enumeration = this.roottocoordinatormap_.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                Configuration.logDebug("Transaction Service: Stopping thread for root " + (String)object2 + "...");
                object = (CoordinatorImp)this.roottocoordinatormap_.get(object2);
                if (object != null) {
                    ((CoordinatorImp)object).dispose();
                }
                Configuration.logDebug("Transaction Service: Thread stopped.");
            }
        }
        enumeration = this.shutdownWaiter_;
        synchronized (enumeration) {
            Configuration.logDebug("Transaction Service: Shutdown acquired lock on waiter.");
            bl2 = this.shuttingDown_;
            this.shuttingDown_ = true;
            while (!this.roottocoordinatormap_.isEmpty() && !bl) {
                try {
                    Configuration.logWarning("Transaction Service: Waiting for non-terminated coordinators...");
                    this.shutdownWaiter_.wait(this.maxTimeout_);
                    Configuration.logDebug("Transaction Service: Purging coordinators for shutdown...");
                    object2 = (Hashtable)this.roottocoordinatormap_.clone();
                    object = ((Hashtable)object2).keys();
                    while (object.hasMoreElements()) {
                        String string = (String)object.nextElement();
                        CoordinatorImp coordinatorImp = (CoordinatorImp)((Hashtable)object2).get(string);
                        if (!TxState.TERMINATED.equals(coordinatorImp.getState())) continue;
                        Configuration.logDebug("Transaction Service: removing terminated coordinator: " + string);
                        this.roottocoordinatormap_.remove(string);
                    }
                }
                catch (InterruptedException interruptedException) {
                    stack.push(interruptedException);
                    throw new SysException("Error in shutdown: " + interruptedException.getMessage(), stack);
                }
            }
            this.notifyListeners(false, true);
            this.initialized_ = false;
            if (!bl2) {
                try {
                    this.recoverymanager_.close();
                }
                catch (LogException logException) {
                    stack.push(logException);
                    throw new SysException("Error in shutdown: " + logException.getMessage(), stack);
                }
            }
        }
        this.notifyListeners(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws Throwable {
        try {
            if (!this.shuttingDown_ && this.initialized_) {
                this.shutdown(true);
            }
        }
        catch (Exception exception) {
            System.err.println("Error in GC of TransactionServiceImp");
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            super.finalize();
        }
    }

    public RecoveryCoordinator getSuperiorRecoveryCoordinator(String string) {
        RecoveryCoordinator recoveryCoordinator = null;
        CoordinatorImp coordinatorImp = this.getCoordinatorImp(string);
        if (coordinatorImp != null) {
            recoveryCoordinator = coordinatorImp.getSuperiorRecoveryCoordinator();
        }
        return recoveryCoordinator;
    }

    public CompositeTransaction createCompositeTransaction(long l) throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.maxActives_ >= 0 && this.tidtotxmap_.size() >= this.maxActives_) {
            throw new IllegalStateException("Max number of active transactions reached:" + this.maxActives_);
        }
        String string = this.tidmgr_.get();
        Stack stack = new Stack();
        CoordinatorImp coordinatorImp = this.createCC(null, string, true, false, l);
        CompositeTransactionImp compositeTransactionImp = this.createCT(string, coordinatorImp, stack, false);
        return compositeTransactionImp;
    }
}

