/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.imp.Reply;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

abstract class Result {
    public static final int ALL_OK = 0;
    public static final int HEUR_HAZARD = 1;
    public static final int HEUR_MIXED = 2;
    public static final int HEUR_ROLLBACK = 3;
    public static final int HEUR_COMMIT = 4;
    public static final int ALL_READONLY = 5;
    public static final int ROLLBACK = 6;
    protected int result_ = -1;
    protected int messagecount_ = 0;
    protected Stack replies_ = new Stack();
    protected Hashtable repliedlist_ = new Hashtable();
    protected Vector msgvector_ = new Vector();
    protected Vector errmsgvector_ = new Vector();

    public Result(int n) {
        this.messagecount_ = n;
    }

    public int getResult() throws IllegalStateException, InterruptedException {
        this.analyze();
        return this.result_;
    }

    protected synchronized void addMessages(HeuristicMessage[] heuristicMessageArray) {
        if (heuristicMessageArray == null) {
            return;
        }
        for (int i = 0; i < heuristicMessageArray.length; ++i) {
            this.msgvector_.addElement(heuristicMessageArray[i]);
        }
    }

    protected synchronized void addErrorMessages(HeuristicMessage[] heuristicMessageArray) {
        if (heuristicMessageArray == null) {
            return;
        }
        for (int i = 0; i < heuristicMessageArray.length; ++i) {
            this.errmsgvector_.addElement(heuristicMessageArray[i]);
        }
    }

    protected abstract void analyze() throws IllegalStateException, InterruptedException;

    public HeuristicMessage[] getMessages() throws IllegalStateException, InterruptedException {
        this.analyze();
        if (this.msgvector_.isEmpty()) {
            return null;
        }
        Object[] objectArray = this.msgvector_.toArray();
        HeuristicMessage[] heuristicMessageArray = new HeuristicMessage[objectArray.length];
        for (int i = 0; i < heuristicMessageArray.length; ++i) {
            heuristicMessageArray[i] = (HeuristicMessage)objectArray[i];
        }
        return heuristicMessageArray;
    }

    public HeuristicMessage[] getErrorMessages() throws IllegalStateException, InterruptedException {
        this.analyze();
        if (this.errmsgvector_.isEmpty()) {
            return null;
        }
        Object[] objectArray = this.errmsgvector_.toArray();
        HeuristicMessage[] heuristicMessageArray = new HeuristicMessage[objectArray.length];
        for (int i = 0; i < heuristicMessageArray.length; ++i) {
            heuristicMessageArray[i] = (HeuristicMessage)objectArray[i];
        }
        return heuristicMessageArray;
    }

    public synchronized void addReply(Reply reply) {
        if (reply.isRetried() || this.repliedlist_.containsKey(reply.getParticipant())) {
            return;
        }
        this.repliedlist_.put(reply.getParticipant(), new Object());
        this.replies_.push(reply);
        --this.messagecount_;
        this.notifyAll();
    }

    public Stack getReplies() throws IllegalStateException, InterruptedException {
        this.waitForReplies();
        return this.replies_;
    }

    synchronized void waitForReplies() throws InterruptedException {
        while (this.messagecount_ > 0) {
            this.wait();
        }
    }
}

