/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.finitestates.FSMEnterEvent;
import com.atomikos.finitestates.FSMEnterListener;
import com.atomikos.icatch.CompositeCoordinator;
import com.atomikos.icatch.CompositeTerminator;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RecoveryCoordinator;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionControl;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.AbstractCompositeTransaction;
import com.atomikos.icatch.imp.CompositeTerminatorImp;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.ExtentImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.icatch.imp.TransactionStateHandler;
import com.atomikos.icatch.imp.TxActiveStateHandler;
import com.atomikos.icatch.system.Configuration;
import java.util.Stack;

public class CompositeTransactionImp
extends AbstractCompositeTransaction
implements TransactionControl,
FSMEnterListener {
    protected CoordinatorImp coordinator_ = null;
    protected TransactionServiceImp txservice_;
    protected Extent extent_ = null;
    protected boolean localRoot_;
    private TransactionStateHandler stateHandler_;

    CompositeTransactionImp(Stack stack, String string, boolean bl, CoordinatorImp coordinatorImp) {
        this(null, stack, string, bl, coordinatorImp);
    }

    public CompositeTransactionImp(TransactionServiceImp transactionServiceImp, Stack stack, String string, boolean bl, CoordinatorImp coordinatorImp) throws IllegalStateException {
        super(string, stack, bl);
        this.coordinator_ = coordinatorImp;
        this.txservice_ = transactionServiceImp;
        this.extent_ = null;
        this.localRoot_ = true;
        this.stateHandler_ = new TxActiveStateHandler(this);
        coordinatorImp.addFSMEnterListener(this, TxState.TERMINATED);
    }

    synchronized void localSetTransactionStateHandler(TransactionStateHandler transactionStateHandler) {
        this.stateHandler_ = transactionStateHandler;
    }

    synchronized void localTestAndSetTransactionStateHandler(TransactionStateHandler transactionStateHandler, TransactionStateHandler transactionStateHandler2) {
        if (this.stateHandler_ != transactionStateHandler) {
            throw new IllegalStateException("State is no longer " + transactionStateHandler.getState() + " but " + transactionStateHandler2.getState());
        }
        this.localSetTransactionStateHandler(transactionStateHandler2);
    }

    synchronized TransactionStateHandler localGetTransactionStateHandler() {
        return this.stateHandler_;
    }

    boolean isLocalRoot() {
        return this.localRoot_;
    }

    TransactionServiceImp getTransactionService() {
        return this.txservice_;
    }

    CoordinatorImp getCoordinatorImp() {
        return this.coordinator_;
    }

    private void printMsg(String string, int n) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TransactionControl getTransactionControl() {
        return this;
    }

    public int getLocalSubTxCount() {
        return this.localGetTransactionStateHandler().getSubTransactionCount();
    }

    public synchronized void setSerial() throws IllegalStateException, SysException {
        if (!this.isRoot()) {
            throw new IllegalStateException("setSerial() not allowed: not root tx.");
        }
        this.serial_ = true;
    }

    public CompositeTransaction createSubTransaction() throws SysException, IllegalStateException {
        CompositeTransaction compositeTransaction = this.localGetTransactionStateHandler().createSubTransaction();
        this.printMsg("createSubTransaction(): created new SUBTRANSACTION " + compositeTransaction.getTid() + " for existing transaction " + this.getTid(), 2);
        return compositeTransaction;
    }

    public RecoveryCoordinator addParticipant(Participant participant) throws SysException, IllegalStateException {
        RecoveryCoordinator recoveryCoordinator = this.localGetTransactionStateHandler().addParticipant(participant);
        this.printMsg("addParticipant ( " + participant + " ) for transaction " + this.getTid(), 2);
        return recoveryCoordinator;
    }

    public void registerSynchronization(Synchronization synchronization) throws IllegalStateException, UnsupportedOperationException, SysException {
        this.localGetTransactionStateHandler().registerSynchronization(synchronization);
    }

    public void addSubTxAwareParticipant(SubTxAwareParticipant subTxAwareParticipant) throws SysException, IllegalStateException {
        this.localGetTransactionStateHandler().addSubTxAwareParticipant(subTxAwareParticipant);
    }

    protected void doRollback() throws IllegalStateException, SysException {
        this.localGetTransactionStateHandler().rollbackWithStateCheck();
        this.printMsg("rollback() done of transaction " + this.getTid(), 2);
    }

    public CompositeCoordinator getCompositeCoordinator() throws SysException {
        return this.coordinator_;
    }

    public boolean isLocal() {
        return true;
    }

    public CompositeTerminator getTerminator() {
        return new CompositeTerminatorImp(this.txservice_, this, this.coordinator_);
    }

    protected void doCommit() throws SysException, IllegalStateException, RollbackException {
        this.localGetTransactionStateHandler().commit();
        this.printMsg("commit() done (by application) of transaction " + this.getTid(), 2);
    }

    public long getTimeout() {
        return this.coordinator_.getTimeOut();
    }

    public synchronized Extent getExtent() {
        if (this.extent_ == null) {
            this.extent_ = new ExtentImp();
        }
        return this.extent_;
    }

    public void setRollbackOnly() {
        this.localGetTransactionStateHandler().setRollbackOnly();
        this.printMsg("setRollbackOnly() called for transaction " + this.getTid(), 2);
    }

    public void commit() throws HeurRollbackException, HeurMixedException, HeurHazardException, SysException, SecurityException, RollbackException {
        this.getTerminator().commit();
    }

    public void rollback() throws IllegalStateException, SysException {
        this.getTerminator().rollback();
    }

    public Object getState() {
        return this.localGetTransactionStateHandler().getState();
    }

    public void entered(FSMEnterEvent fSMEnterEvent) {
        if (this.getState().equals(TxState.ACTIVE) || this.getState().equals(TxState.MARKED_ABORT)) {
            try {
                this.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

