/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.diagnostics.Console;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CompositeTransactionImp;
import com.atomikos.icatch.imp.TransactionServiceImp;
import com.atomikos.icatch.system.Configuration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;

public class BaseTransactionManager
implements CompositeTransactionManager,
SubTxAwareParticipant {
    private Hashtable threadtotxmap_ = new Hashtable();
    private Hashtable txtothreadmap_ = new Hashtable();
    private TransactionServiceImp service_;
    private boolean initialized_ = false;

    protected BaseTransactionManager() {
    }

    protected void printMsg(String string, int n) {
        try {
            Console console = Configuration.getConsole();
            if (console != null) {
                console.println(string, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getThread(CompositeTransaction compositeTransaction) {
        Thread thread = null;
        Hashtable hashtable = this.txtothreadmap_;
        synchronized (hashtable) {
            thread = (Thread)this.txtothreadmap_.get(compositeTransaction);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack removeThreadMappings(Thread thread) {
        Stack stack = null;
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            stack = (Stack)this.threadtotxmap_.remove(thread);
            CompositeTransaction compositeTransaction = (CompositeTransaction)stack.peek();
            this.txtothreadmap_.remove(compositeTransaction);
        }
        return stack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThreadMappings(CompositeTransaction compositeTransaction, Thread thread) throws IllegalStateException, SysException {
        compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            if (TxState.ACTIVE.equals(compositeTransaction.getState())) {
                Stack<CompositeTransaction> stack = (Stack<CompositeTransaction>)this.threadtotxmap_.get(thread);
                if (stack == null) {
                    stack = new Stack<CompositeTransaction>();
                }
                stack.push(compositeTransaction);
                this.threadtotxmap_.put(thread, stack);
                this.txtothreadmap_.put(compositeTransaction, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreThreadMappings(Stack stack, Thread thread) throws IllegalStateException {
        CompositeTransaction compositeTransaction = (CompositeTransaction)stack.peek();
        compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            if (TxState.ACTIVE.equals(compositeTransaction.getState())) {
                Stack stack2 = (Stack)this.threadtotxmap_.get(thread);
                if (stack2 != null) {
                    throw new IllegalStateException("Thread already has subtx stack");
                }
                this.threadtotxmap_.put(thread, stack);
                this.txtothreadmap_.put(compositeTransaction, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeTransactionImp getCurrentTx() {
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.threadtotxmap_;
        synchronized (hashtable) {
            Stack stack = (Stack)this.threadtotxmap_.get(thread);
            if (stack == null) {
                return null;
            }
            return (CompositeTransactionImp)stack.peek();
        }
    }

    public void init(TransactionServiceImp transactionServiceImp, Properties properties) throws SysException {
        this.service_ = transactionServiceImp;
        this.service_.init(properties);
        this.initialized_ = true;
    }

    public Participant getParticipant(String string) {
        return this.service_.getParticipant(string);
    }

    public void committed(CompositeTransaction compositeTransaction) {
        this.removeTransaction(compositeTransaction);
    }

    public void rolledback(CompositeTransaction compositeTransaction) {
        this.removeTransaction(compositeTransaction);
    }

    public CompositeTransaction getCompositeTransaction() throws SysException {
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CompositeTransactionImp compositeTransactionImp = null;
        compositeTransactionImp = this.getCurrentTx();
        if (compositeTransactionImp != null) {
            this.printMsg("getCompositeTransaction()  returning instance with id " + compositeTransactionImp.getTid(), 2);
        } else {
            this.printMsg("getCompositeTransaction() returning NULL!", 2);
        }
        return compositeTransactionImp;
    }

    public CompositeTransaction getCompositeTransaction(String string) throws SysException {
        CompositeTransaction compositeTransaction = this.service_.getCompositeTransaction(string);
        if (compositeTransaction != null) {
            this.printMsg("getCompositeTransaction ( " + string + " ) returning instance with tid " + compositeTransaction.getTid(), 2);
        } else {
            this.printMsg("getCompositeTransaction ( " + string + " ) returning NULL!", 2);
        }
        return compositeTransaction;
    }

    protected synchronized CompositeTransaction recreateCompositeTransaction(Propagation propagation, boolean bl, boolean bl2) throws SysException {
        Object object;
        CompositeTransactionImp compositeTransactionImp = null;
        compositeTransactionImp = this.getCurrentTx();
        if (compositeTransactionImp != null) {
            object = "Recreating a transaction with existing transaction: " + compositeTransactionImp.getTid();
            this.printMsg((String)object, 1);
        }
        compositeTransactionImp = this.service_.recreateCompositeTransaction(propagation, bl, bl2);
        object = Thread.currentThread();
        this.setThreadMappings(compositeTransactionImp, (Thread)object);
        return compositeTransactionImp;
    }

    public CompositeTransaction suspend() throws SysException {
        Thread thread = Thread.currentThread();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        CompositeTransactionImp compositeTransactionImp = this.getCurrentTx();
        if (compositeTransactionImp != null) {
            this.printMsg("suspend() for transaction " + compositeTransactionImp.getTid(), 2);
            this.removeThreadMappings(thread);
        } else {
            this.printMsg("suspend() called without a transaction context", 2);
        }
        return compositeTransactionImp;
    }

    public void resume(CompositeTransaction compositeTransaction) throws IllegalStateException, SysException {
        Thread thread = Thread.currentThread();
        if (!this.initialized_) {
            throw new IllegalStateException("Not initialized");
        }
        Stack stack = new Stack();
        Stack<CompositeTransaction> stack2 = new Stack<CompositeTransaction>();
        Stack stack3 = (Stack)compositeTransaction.getLineage().clone();
        boolean bl = false;
        while (!stack3.isEmpty() && !bl) {
            CompositeTransaction compositeTransaction2 = (CompositeTransaction)stack3.pop();
            if (!compositeTransaction2.isLocal()) {
                bl = true;
                continue;
            }
            stack2.push(compositeTransaction2);
        }
        while (!stack2.isEmpty()) {
            stack.push(stack2.pop());
        }
        stack.push(compositeTransaction);
        this.restoreThreadMappings(stack, thread);
        this.printMsg("resume ( " + compositeTransaction + " ) done for transaction " + compositeTransaction.getTid(), 2);
    }

    public void shutdown(boolean bl) throws SysException, IllegalStateException {
        this.service_.shutdown(bl);
    }

    protected void startlistening(CompositeTransaction compositeTransaction) throws SysException {
        compositeTransaction.addSubTxAwareParticipant((SubTxAwareParticipant)this);
    }

    private void removeTransaction(CompositeTransaction compositeTransaction) {
        if (compositeTransaction == null) {
            return;
        }
        Thread thread = this.getThread(compositeTransaction);
        if (thread == null) {
            return;
        }
        Stack stack = this.removeThreadMappings(thread);
        if (stack != null && !stack.empty()) {
            stack.pop();
            if (!stack.empty()) {
                this.restoreThreadMappings(stack, thread);
            }
        }
    }

    public CompositeTransaction createCompositeTransaction(long l) throws SysException {
        Stack stack = new Stack();
        CompositeTransactionImp compositeTransactionImp = null;
        CompositeTransaction compositeTransaction = null;
        Thread thread = Thread.currentThread();
        compositeTransactionImp = this.getCurrentTx();
        if (compositeTransactionImp == null) {
            compositeTransaction = this.service_.createCompositeTransaction(l);
            this.printMsg("createCompositeTransaction ( " + l + " ): " + "created new ROOT transaction with id " + compositeTransaction.getTid(), 2);
        } else {
            this.printMsg("createCompositeTransaction ( " + l + " )", 2);
            compositeTransaction = compositeTransactionImp.getTransactionControl().createSubTransaction();
        }
        this.setThreadMappings(compositeTransaction, thread);
        return compositeTransaction;
    }
}

