/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TxState;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.IndoubtStateHandler;
import com.atomikos.icatch.imp.PrepareMessage;
import com.atomikos.icatch.imp.PrepareResult;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.icatch.system.Configuration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

class ActiveStateHandler
extends CoordinatorStateHandler {
    private long rollbackTicks_ = 0L;
    private int globalSiblingCount_;

    ActiveStateHandler(CoordinatorImp coordinatorImp) {
        super(coordinatorImp);
    }

    protected long getRollbackTicks() {
        return this.rollbackTicks_;
    }

    protected Object getState() {
        return TxState.ACTIVE;
    }

    protected void onTimeout() {
        try {
            if (this.rollbackTicks_ < this.getCoordinator().getMaxRollbackTicks()) {
                ++this.rollbackTicks_;
            } else if (this.getCoordinator().getState().equals(this.getState())) {
                this.printMsg("Rollback of timedout ACTIVE coordinator !");
                boolean bl = this.getCoordinator().isRecoverableWhileActive();
                super.rollback(bl, false);
            }
        }
        catch (Exception exception) {
            this.printMsg("Error in timeout of ACTIVE state: " + exception.getMessage() + " for coordinator " + this.getCoordinator().getCoordinatorId());
        }
    }

    protected void setGlobalSiblingCount(int n) {
        this.globalSiblingCount_ = n;
    }

    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        CoordinatorStateHandler coordinatorStateHandler;
        int n;
        boolean bl;
        block13: {
            Stack<Throwable> stack = new Stack<Throwable>();
            int n2 = 0;
            PrepareResult prepareResult = null;
            bl = true;
            n = 0;
            Hashtable hashtable = this.getCoordinator().getParticipants();
            coordinatorStateHandler = null;
            if (this.getCoordinator().checkSiblings() && this.globalSiblingCount_ != this.getCoordinator().getLocalSiblingCount()) {
                try {
                    Configuration.logDebug("Orphans detected: " + this.getCoordinator().getLocalSiblingCount() + " vs " + this.globalSiblingCount_ + " - forcing rollback.");
                    super.rollback(this.getCoordinator().isRecoverableWhileActive(), false);
                }
                catch (HeurCommitException heurCommitException) {
                    throw new HeurMixedException(heurCommitException.getHeuristicMessages());
                }
                throw new RollbackException("Orphans detected.");
            }
            try {
                this.getCoordinator().setState(TxState.PREPARING);
                n2 = hashtable.size();
                prepareResult = new PrepareResult(n2);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Participant participant = (Participant)enumeration.nextElement();
                    PrepareMessage prepareMessage = new PrepareMessage(participant, prepareResult);
                    if (this.getCascadeList() != null && participant.getURI() != null) {
                        Integer n3 = (Integer)this.getCascadeList().get(participant.getURI());
                        if (n3 != null) {
                            participant.setGlobalSiblingCount(n3.intValue());
                        }
                        participant.setCascadeList(this.getCascadeList());
                    }
                    this.getPropagator().submitPropagationMessage(prepareMessage);
                }
                prepareResult.waitForReplies();
                boolean bl2 = prepareResult.allYes();
                this.setReadOnlyTable(prepareResult.getReadOnlyTable());
                bl = prepareResult.allReadOnly();
                if (bl2) break block13;
                int n4 = prepareResult.getResult();
                try {
                    this.rollback(true, false);
                }
                catch (HeurCommitException heurCommitException) {
                    stack.push(heurCommitException);
                    throw new SysException("Unexpected heuristic: " + heurCommitException.getMessage(), stack);
                }
                throw new RollbackException("Prepare: NO vote");
            }
            catch (RuntimeException runtimeException) {
                stack.push(runtimeException);
                throw new SysException("Error in prepare: " + runtimeException.getMessage(), stack);
            }
            catch (InterruptedException interruptedException) {
                stack.push(interruptedException);
                throw new SysException("Error in prepare: " + interruptedException.getMessage(), stack);
            }
        }
        if (bl) {
            coordinatorStateHandler = new TerminatedStateHandler(this);
            this.getCoordinator().setStateHandler(coordinatorStateHandler);
            n = 0;
        } else {
            coordinatorStateHandler = new IndoubtStateHandler(this);
            this.getCoordinator().setStateHandler(coordinatorStateHandler);
            n = 1;
        }
        return n;
    }

    protected HeuristicMessage[] commit(boolean bl) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        HeuristicMessage[] heuristicMessageArray = new HeuristicMessage[]{};
        if (!bl) {
            throw new IllegalStateException("Illegal state for commit: ACTIVE!");
        }
        if (this.getCoordinator().getParticipants().size() > 1) {
            int n = 1;
            this.setGlobalSiblingCount(1);
            n = this.prepare();
            heuristicMessageArray = n == 0 ? this.getHeuristicMessages() : this.commit(false, false);
        } else {
            heuristicMessageArray = this.commit(false, true);
        }
        return heuristicMessageArray;
    }

    protected HeuristicMessage[] rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        return this.rollback(this.getCoordinator().isRecoverableWhileActive(), false);
    }

    protected Boolean replayCompletion(Participant participant) throws IllegalStateException {
        throw new IllegalStateException("No prepares sent yet.");
    }
}

