/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.admin.imp;

import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.admin.LogControl;
import com.atomikos.icatch.admin.imp.AdminTool;
import com.atomikos.icatch.config.UserTransactionService;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class LocalLogAdministrator
implements ActionListener,
LogAdministrator {
    private JFrame frame_;
    private UserTransactionService service_;
    private JMenuItem inspect_;
    private JMenuItem exit_;
    private LogControl control_;
    private ResourceBundle messages_;

    public LocalLogAdministrator(String string, boolean bl) {
        this.frame_ = new JFrame(string);
        this.frame_.setDefaultCloseOperation(0);
        this.messages_ = ResourceBundle.getBundle("com.atomikos.icatch.admin.AdminToolResourceBundle");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(this.messages_.getString("mainMenuName"));
        jMenu.setMnemonic(77);
        this.inspect_ = new JMenuItem(this.messages_.getString("showActiveTransactionsMenuItemName") + "...", this.messages_.getString("showActiveTransactionsMenuItemName").charAt(0));
        this.inspect_.addActionListener(this);
        this.inspect_.setEnabled(false);
        jMenu.add(this.inspect_);
        if (bl) {
            this.exit_ = new JMenuItem(this.messages_.getString("exitMenuItemName"), this.messages_.getString("exitMenuItemName").charAt(0));
            this.exit_.addActionListener(this);
            jMenu.add(this.exit_);
        }
        jMenuBar.add(jMenu);
        this.frame_.setJMenuBar(jMenuBar);
        Dimension dimension = new Dimension(486, 380);
        this.frame_.setSize(dimension);
        this.frame_.setVisible(true);
    }

    public void registerLogControl(LogControl logControl) {
        if (this.control_ != null) {
            throw new IllegalStateException("Second control registered");
        }
        this.control_ = logControl;
        this.inspect_.setEnabled(true);
    }

    public void deregisterLogControl(LogControl logControl) {
        if (this.control_ == logControl) {
            this.control_ = null;
        }
        this.inspect_.setEnabled(false);
        this.frame_.dispose();
    }

    public void init(UserTransactionService userTransactionService) {
        this.service_ = userTransactionService;
        this.frame_.show();
    }

    public JFrame getJFrame() {
        return this.frame_;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource() == this.inspect_) {
                if (this.control_ != null) {
                    try {
                        AdminTool adminTool = new AdminTool(this.control_);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    System.err.println("LogAdministrator: no control registered?");
                }
            } else if (actionEvent.getSource() == this.exit_) {
                try {
                    if (this.service_ != null) {
                        this.service_.shutdown(true);
                    }
                    System.exit(0);
                }
                catch (IllegalStateException illegalStateException) {
                    int n = JOptionPane.showConfirmDialog(this.frame_, this.messages_.getString("shutdownMessage"), this.messages_.getString("shutdownTitle"), 0);
                    if (n == 0) {
                        this.service_.shutdown(true);
                        System.exit(0);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

