/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.spring;

import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.spring.AtomikosDependsOnBeanFactoryPostProcessor;
import com.atomikos.spring.AtomikosProperties;
import com.atomikos.spring.AtomikosXAConnectionFactoryWrapper;
import com.atomikos.spring.AtomikosXADataSourceWrapper;
import com.atomikos.spring.SpringJtaAtomikosProperties;
import jakarta.jms.Message;
import jakarta.transaction.UserTransaction;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.artemis.ArtemisAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.boot.jms.XAConnectionFactoryWrapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SpringJtaAtomikosProperties.class, AtomikosProperties.class})
@ConditionalOnClass(value={JtaTransactionManager.class, UserTransactionManager.class})
@ConditionalOnMissingBean(value={TransactionManager.class})
@AutoConfigureBefore(value={XADataSourceAutoConfiguration.class, ArtemisAutoConfiguration.class, HibernateJpaAutoConfiguration.class}, name={"org.springframework.boot.autoconfigure.transaction.jta.JtaAutoConfiguration"})
public class AtomikosAutoConfiguration {
    @Bean(initMethod="init", destroyMethod="shutdownWait")
    @ConditionalOnMissingBean(value={UserTransactionService.class})
    UserTransactionServiceImp userTransactionService(SpringJtaAtomikosProperties springJtaAtomikosProperties, AtomikosProperties atomikosProperties) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)springJtaAtomikosProperties.asProperties());
        properties.putAll((Map<?, ?>)atomikosProperties.asProperties());
        return new UserTransactionServiceImp(properties);
    }

    @Bean(initMethod="init", destroyMethod="close")
    @ConditionalOnMissingBean(value={jakarta.transaction.TransactionManager.class})
    UserTransactionManager atomikosTransactionManager(UserTransactionService userTransactionService) throws Exception {
        UserTransactionManager manager = new UserTransactionManager();
        manager.setStartupTransactionService(false);
        manager.setForceShutdown(true);
        return manager;
    }

    @Bean
    @ConditionalOnMissingBean(value={XADataSourceWrapper.class})
    AtomikosXADataSourceWrapper xaDataSourceWrapper() {
        return new AtomikosXADataSourceWrapper();
    }

    @Bean
    @ConditionalOnMissingBean
    static AtomikosDependsOnBeanFactoryPostProcessor atomikosDependsOnBeanFactoryPostProcessor() {
        return new AtomikosDependsOnBeanFactoryPostProcessor();
    }

    @Bean
    JtaTransactionManager transactionManager(UserTransaction userTransaction, jakarta.transaction.TransactionManager transactionManager, ObjectProvider<TransactionManagerCustomizers> transactionManagerCustomizers) {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(userTransaction, transactionManager);
        transactionManagerCustomizers.ifAvailable(customizers -> customizers.customize((PlatformTransactionManager)jtaTransactionManager));
        return jtaTransactionManager;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Message.class})
    static class AtomikosJtaJmsConfiguration {
        AtomikosJtaJmsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={XAConnectionFactoryWrapper.class})
        AtomikosXAConnectionFactoryWrapper xaConnectionFactoryWrapper() {
            return new AtomikosXAConnectionFactoryWrapper();
        }
    }
}

