/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.provider;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public final class ConfigProperties {
    public static final String TM_UNIQUE_NAME_PROPERTY_NAME = "com.atomikos.icatch.tm_unique_name";
    public static final String LOG_BASE_DIR_PROPERTY_NAME = "com.atomikos.icatch.log_base_dir";
    public static final String LOG_BASE_NAME_PROPERTY_NAME = "com.atomikos.icatch.log_base_name";
    public static final String ENABLE_LOGGING_PROPERTY_NAME = "com.atomikos.icatch.enable_logging";
    public static final String MAX_TIMEOUT_PROPERTY_NAME = "com.atomikos.icatch.max_timeout";
    public static final String MAX_ACTIVES_PROPERTY_NAME = "com.atomikos.icatch.max_actives";
    public static final String FORCE_SHUTDOWN_ON_VM_EXIT_PROPERTY_NAME = "com.atomikos.icatch.force_shutdown_on_vm_exit";
    public static final String FILE_PATH_PROPERTY_NAME = "com.atomikos.icatch.file";
    public static final String CHECKPOINT_INTERVAL = "com.atomikos.icatch.checkpoint_interval";
    public static final String FORGET_ORPHANED_LOG_ENTRIES_DELAY = "com.atomikos.icatch.forget_orphaned_log_entries_delay";
    public static final String OLTP_MAX_RETRIES_PROPERTY_NAME = "com.atomikos.icatch.oltp_max_retries";
    public static final String OLTP_RETRY_INTERVAL = "com.atomikos.icatch.oltp_retry_interval";
    public static final String RECOVERY_DELAY = "com.atomikos.icatch.recovery_delay";
    public static final String ALLOW_SUBTRANSACTIONS = "com.atomikos.icatch.allow_subtransactions";
    public static final String DEFAULT_MAX_WAIT_TIME_ON_SHUTDOWN = "com.atomikos.icatch.default_max_wait_time_on_shutdown";
    public static final String THROW_ON_HEURISTIC = "com.atomikos.icatch.throw_on_heuristic";
    public static final String RECOVERY_COORDINATOR_BASE_URI = "com.atomikos.icatch.recovery_coordinator_base_uri";
    public static final String JVM_ID_PROPERTY_NAME = "com.atomikos.icatch.jvm_id";
    private Properties properties;

    private static String evaluateReference(String value, Properties properties) {
        String result = value;
        int startIndex = value.indexOf(36);
        if (startIndex > -1 && value.charAt(startIndex + 1) == '{') {
            int endIndex = value.indexOf(125);
            if (startIndex + 2 == endIndex) {
                throw new IllegalArgumentException("property ref cannot refer to an empty name: ${}");
            }
            if (endIndex == -1) {
                throw new IllegalArgumentException("unclosed property ref: ${" + value.substring(startIndex + 2));
            }
            String subPropertyKey = value.substring(startIndex + 2, endIndex);
            String subPropertyValue = properties.getProperty(subPropertyKey);
            if (subPropertyValue == null) {
                subPropertyValue = System.getProperty(subPropertyKey);
            }
            if (subPropertyValue != null) {
                result = result.substring(0, startIndex) + subPropertyValue + result.substring(endIndex + 1);
                result = ConfigProperties.evaluateReference(result, properties);
            }
        }
        return result;
    }

    private static String getDefaultName() {
        String ret = "tm";
        try {
            ret = InetAddress.getLocalHost().getHostAddress() + ".tm";
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ret;
    }

    public ConfigProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties should not be null");
        }
        this.properties = properties;
    }

    private void setDefaultTmUniqueName() {
        if (this.properties.getProperty(TM_UNIQUE_NAME_PROPERTY_NAME) == null) {
            this.properties.setProperty(TM_UNIQUE_NAME_PROPERTY_NAME, ConfigProperties.getDefaultName());
        }
    }

    private void setDefaultJvmId() {
        if (this.properties.getProperty(JVM_ID_PROPERTY_NAME) == null) {
            this.properties.setProperty(JVM_ID_PROPERTY_NAME, this.getDefaultJvmId());
        }
    }

    private String getDefaultJvmId() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    private void applySystemProperties() {
        Properties systemProperties = System.getProperties();
        Enumeration<?> propertyNames = systemProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            if (!name.startsWith("com.atomikos")) continue;
            this.properties.setProperty(name, systemProperties.getProperty(name));
        }
    }

    private void substitutePlaceHolderValues() {
        Enumeration<?> allProps = this.properties.propertyNames();
        while (allProps.hasMoreElements()) {
            String value;
            String key = (String)allProps.nextElement();
            String raw = this.properties.getProperty(key);
            if (raw.equals(value = ConfigProperties.evaluateReference(raw, this.properties))) continue;
            this.properties.setProperty(key, value);
        }
    }

    public String getProperty(String name) {
        this.completeProperties();
        String ret = this.properties.getProperty(name);
        if (ret == null) {
            throw new IllegalArgumentException("Missing required property: " + name);
        }
        ret = ret.trim();
        return ret;
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public boolean getAsBoolean(String name) {
        boolean ret = false;
        String retAsString = this.getProperty(name);
        ret = Boolean.valueOf(retAsString);
        return ret;
    }

    public int getAsInt(String name) {
        String retAsString = this.getProperty(name);
        return Integer.valueOf(retAsString);
    }

    public long getAsLong(String name) {
        String retAsString = this.getProperty(name);
        return Long.valueOf(retAsString);
    }

    public String getTmUniqueName() {
        return this.getProperty(TM_UNIQUE_NAME_PROPERTY_NAME);
    }

    public String getLogBaseDir() {
        return this.getProperty(LOG_BASE_DIR_PROPERTY_NAME);
    }

    public String getLogBaseName() {
        return this.getProperty(LOG_BASE_NAME_PROPERTY_NAME);
    }

    public boolean getEnableLogging() {
        return this.getAsBoolean(ENABLE_LOGGING_PROPERTY_NAME);
    }

    public long getMaxTimeout() {
        return this.getAsLong(MAX_TIMEOUT_PROPERTY_NAME);
    }

    public int getMaxActives() {
        return this.getAsInt(MAX_ACTIVES_PROPERTY_NAME);
    }

    public long getCheckpointInterval() {
        return this.getAsLong(CHECKPOINT_INTERVAL);
    }

    public void applyUserSpecificProperties(Properties userSpecificProperties) {
        Enumeration<?> names = userSpecificProperties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.properties.setProperty(name, userSpecificProperties.getProperty(name));
        }
    }

    public Properties getCompletedProperties() {
        Properties ret = new Properties();
        this.completeProperties();
        Enumeration<?> propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            ret.setProperty(name, this.getProperty(name));
        }
        return ret;
    }

    private void completeProperties() {
        this.applySystemProperties();
        this.substitutePlaceHolderValues();
        this.setDefaultTmUniqueName();
        this.setDefaultJvmId();
    }

    public boolean getForceShutdownOnVmExit() {
        return this.getAsBoolean(FORCE_SHUTDOWN_ON_VM_EXIT_PROPERTY_NAME);
    }

    public long getForgetOrphanedLogEntriesDelay() {
        return this.getAsLong(FORGET_ORPHANED_LOG_ENTRIES_DELAY);
    }

    public int getOltpMaxRetries() {
        return this.getAsInt(OLTP_MAX_RETRIES_PROPERTY_NAME);
    }

    public long getOltpRetryInterval() {
        return this.getAsInt(OLTP_RETRY_INTERVAL);
    }

    public long getRecoveryDelay() {
        return this.getAsLong(RECOVERY_DELAY);
    }

    public boolean getAllowSubTransactions() {
        return this.getAsBoolean(ALLOW_SUBTRANSACTIONS);
    }

    public long getDefaultMaxWaitTimeOnShutdown() {
        return this.getAsLong(DEFAULT_MAX_WAIT_TIME_ON_SHUTDOWN);
    }

    public boolean getThrowOnHeuristic() {
        return this.getAsBoolean(THROW_ON_HEURISTIC);
    }

    public String getJvmId() {
        return this.getProperty(JVM_ID_PROPERTY_NAME);
    }
}

