/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.config;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TSListener;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.config.TSInitInfo;
import com.atomikos.icatch.config.TSMetaData;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class UserTransactionServiceImp
implements Serializable,
UserTransactionService {
    public static final String NO_FILE_PROPERTY_NAME = "com.atomikos.icatch.no_file";
    public static final String FILE_PATH_PROPERTY_NAME = "com.atomikos.icatch.file";
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "transactions.properties";
    private static final String PRE_3_0_DEFAULT_PROPERTIES_FILE_NAME = "jta.properties";
    private Properties properties_;
    private transient UserTransactionService delegate_;

    private static String evaluateReference(String string, Properties properties) {
        String string2 = string;
        int n = string.indexOf(36);
        if (n > -1 && string.charAt(n + 1) == '{') {
            int n2 = string.indexOf(125);
            if (n + 2 == n2) {
                throw new IllegalArgumentException("property ref cannot refer to an empty name: ${}");
            }
            if (n2 == -1) {
                throw new IllegalArgumentException("unclosed property ref: ${" + string.substring(n + 2));
            }
            String string3 = string.substring(n + 2, n2);
            String string4 = properties.getProperty(string3);
            if (string4 == null) {
                string4 = System.getProperty(string3);
            }
            if (string4 != null) {
                string2 = string2.substring(0, n) + string4 + string2.substring(n2 + 1);
                string2 = UserTransactionServiceImp.evaluateReference(string2, properties);
            }
        }
        return string2;
    }

    private static Properties mergeProperties(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            properties2.setProperty(string, string2);
        }
        return properties2;
    }

    private URL findPropertiesFileInClasspath(String string) {
        URL uRL = null;
        String string2 = "/";
        if (string.startsWith("/")) {
            string2 = "";
        }
        if ((uRL = this.getClass().getResource(string2 + string)) == null) {
            this.getClass().getClassLoader();
            uRL = ClassLoader.getSystemResource(string);
        }
        return uRL;
    }

    private Properties getProperties() {
        String string;
        Object object;
        Object object2;
        Properties properties = new Properties();
        URL uRL = null;
        if (System.getProperty(NO_FILE_PROPERTY_NAME) == null) {
            object2 = System.getProperty(FILE_PATH_PROPERTY_NAME);
            if (object2 == null) {
                object2 = DEFAULT_PROPERTIES_FILE_NAME;
                System.err.println("No properties path set - looking for transactions.properties in classpath...");
                uRL = this.findPropertiesFileInClasspath((String)object2);
                if (uRL == null) {
                    object2 = PRE_3_0_DEFAULT_PROPERTIES_FILE_NAME;
                    System.err.println("transactions.properties not found - looking for jta.properties in classpath...");
                    uRL = this.findPropertiesFileInClasspath((String)object2);
                }
            } else {
                object = new File((String)object2);
                try {
                    uRL = ((File)object).toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                if (uRL == null) {
                    throw new IOException();
                }
                System.err.println("Using init file: " + uRL.getPath());
                object = uRL.openStream();
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                string = "Failed to open transactions properties file - using default values";
                System.err.println(string);
                properties.setProperty("com.atomikos.icatch.service", "com.atomikos.icatch.standalone.UserTransactionServiceFactory");
            }
        } else {
            properties.setProperty("com.atomikos.icatch.service", System.getProperty("com.atomikos.icatch.service"));
        }
        object2 = properties.propertyNames();
        while (object2.hasMoreElements()) {
            String string2;
            object = (String)object2.nextElement();
            string = properties.getProperty((String)object);
            if (string.equals(string2 = UserTransactionServiceImp.evaluateReference(string, properties))) continue;
            properties.setProperty((String)object, string2);
        }
        return properties;
    }

    private String getProperty(String string) {
        if (this.properties_ == null) {
            this.properties_ = this.getProperties();
        }
        return this.properties_.getProperty(string);
    }

    public UserTransactionServiceImp() {
    }

    public UserTransactionServiceImp(Properties properties) {
        this.properties_ = this.getProperties();
        this.properties_.putAll((Map<?, ?>)properties);
    }

    private void checkInit() {
        if (this.delegate_ != null) {
            return;
        }
        String string = this.getProperty("com.atomikos.icatch.service");
        if (string == null) {
            throw new SysException("UserTransactionServiceImp: property not defined: com.atomikos.icatch.service");
        }
        try {
            Class<?> clazz = Class.forName(string);
            UserTransactionServiceFactory userTransactionServiceFactory = (UserTransactionServiceFactory)clazz.newInstance();
            this.delegate_ = userTransactionServiceFactory.getUserTransactionService(this.properties_);
        }
        catch (Exception exception) {
            Stack<Exception> stack = new Stack<Exception>();
            stack.push(exception);
            throw new SysException("Error in init of UserTransactionServiceImp: " + exception.getMessage(), stack);
        }
    }

    public TSInitInfo createTSInitInfo() {
        TSInitInfo tSInitInfo = null;
        this.checkInit();
        tSInitInfo = this.delegate_.createTSInitInfo();
        Properties properties = UserTransactionServiceImp.mergeProperties(this.properties_, tSInitInfo.getProperties());
        tSInitInfo.setProperties(properties);
        return tSInitInfo;
    }

    public void shutdown(boolean bl) throws IllegalStateException {
        this.checkInit();
        this.delegate_.shutdown(bl);
    }

    public void init(TSInitInfo tSInitInfo) throws SysException {
        this.checkInit();
        this.delegate_.init(tSInitInfo);
    }

    public CompositeTransactionManager getCompositeTransactionManager() {
        this.checkInit();
        return this.delegate_.getCompositeTransactionManager();
    }

    public TransactionManager getTransactionManager() {
        this.checkInit();
        return this.delegate_.getTransactionManager();
    }

    public UserTransaction getUserTransaction() {
        this.checkInit();
        return this.delegate_.getUserTransaction();
    }

    public ImportingTransactionManager getImportingTransactionManager() {
        this.checkInit();
        return this.delegate_.getImportingTransactionManager();
    }

    public ExportingTransactionManager getExportingTransactionManager() {
        this.checkInit();
        return this.delegate_.getExportingTransactionManager();
    }

    public TSMetaData getTSMetaData() {
        this.checkInit();
        return this.delegate_.getTSMetaData();
    }

    public void registerResource(RecoverableResource recoverableResource) {
        this.checkInit();
        this.delegate_.registerResource(recoverableResource);
    }

    public void registerLogAdministrator(LogAdministrator logAdministrator) {
        this.checkInit();
        this.delegate_.registerLogAdministrator(logAdministrator);
    }

    public Enumeration getResources() {
        this.checkInit();
        return this.delegate_.getResources();
    }

    public Enumeration getLogAdministrators() {
        this.checkInit();
        return this.delegate_.getLogAdministrators();
    }

    public void removeResource(RecoverableResource recoverableResource) {
        this.checkInit();
        this.delegate_.removeResource(recoverableResource);
    }

    public void removeLogAdministrator(LogAdministrator logAdministrator) {
        this.checkInit();
        this.delegate_.removeLogAdministrator(logAdministrator);
    }

    public void registerTSListener(TSListener tSListener) {
        this.checkInit();
        this.delegate_.registerTSListener(tSListener);
    }

    public void removeTSListener(TSListener tSListener) {
        this.checkInit();
        this.delegate_.removeTSListener(tSListener);
    }

    public void shutdownForce() {
        this.shutdown(true);
    }

    public void shutdownWait() {
        this.shutdown(false);
    }

    public void setRecoverableResources(List list) {
        this.checkInit();
        this.delegate_.setRecoverableResources(list);
    }

    public void setLogAdministrators(List list) {
        this.checkInit();
        this.delegate_.setLogAdministrators(list);
    }

    public void setTSListeners(List list) {
        this.checkInit();
        this.delegate_.setTSListeners(list);
    }
}

