/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlFrame
implements HyperlinkListener,
ActionListener {
    private JFrame win_;
    private JEditorPane pane_ = new JEditorPane();
    private Stack stack_;
    private JButton back_;
    private URL lastUrl_;
    private JDialog dialog_;

    public HtmlFrame(URL url, JFrame parent) throws IOException {
        JScrollPane scrollpane = new JScrollPane(this.pane_);
        this.pane_.setEditable(false);
        this.pane_.setPage(url);
        this.pane_.addHyperlinkListener(this);
        ImageIcon backImageIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Back24.gif"));
        this.back_ = new JButton(backImageIcon);
        this.back_.setEnabled(false);
        this.back_.addActionListener(this);
        JPanel panel = new JPanel();
        panel.add(this.back_);
        this.stack_ = new Stack();
        this.lastUrl_ = url;
        if (parent == null) {
            this.win_ = new JFrame("HtmlViewer");
            this.win_.getContentPane().setLayout(new BorderLayout());
            this.win_.getContentPane().add((Component)scrollpane, "Center");
            this.win_.getContentPane().add((Component)panel, "North");
            this.win_.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            Dimension defaultSize = new Dimension(600, 700);
            this.win_.setSize(defaultSize);
            this.win_.setVisible(true);
        } else {
            this.win_ = parent;
            JPanel pane = new JPanel();
            pane.setLayout(new BorderLayout());
            pane.add((Component)scrollpane, "Center");
            pane.add((Component)panel, "North");
            pane.setSize(new Dimension(500, 500));
            JDialog dialog = new JDialog(parent, "HtmlViewer", true);
            dialog.setContentPane(pane);
            dialog.pack();
            dialog.setSize(new Dimension(500, 500));
            dialog.setVisible(true);
            this.dialog_ = dialog;
        }
    }

    private void setWaitCursor(boolean wait) {
        Cursor cursor = null;
        cursor = wait ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0);
        if (this.dialog_ != null) {
            this.dialog_.getContentPane().setCursor(cursor);
        } else {
            this.win_.getContentPane().setCursor(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL url, boolean addToStack) {
        try {
            this.setWaitCursor(true);
            this.pane_.setPage(url);
            if (addToStack) {
                this.stack_.push(this.lastUrl_);
                this.back_.setEnabled(true);
            }
            this.lastUrl_ = url;
        }
        catch (IOException err) {
            System.err.println("Bad URL: " + url);
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        JEditorPane pane = (JEditorPane)e.getSource();
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            this.load(url, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.back_) {
            this.load((URL)this.stack_.pop(), false);
            if (this.stack_.empty()) {
                this.back_.setEnabled(false);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: specify the URL to load");
            System.exit(1);
        }
        try {
            HtmlFrame frame = new HtmlFrame(new URL(args[0]), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

