/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;

public class IntraVmObjectRegistry {
    private static final Map resourcesMap = new HashMap();

    public static synchronized void addResource(String resourceName, Object resource) throws NameAlreadyBoundException {
        if (resourcesMap.containsKey(resourceName)) {
            throw new NameAlreadyBoundException("resource with name '" + resourceName + "' already registered");
        }
        resourcesMap.put(resourceName, resource);
    }

    public static synchronized Object getResource(String resourceName) throws NameNotFoundException {
        if (!resourcesMap.containsKey(resourceName)) {
            throw new NameNotFoundException("no resource with name '" + resourceName + "' has been registered yet");
        }
        return resourcesMap.get(resourceName);
    }

    public static synchronized void removeResource(String resourceName) throws NameNotFoundException {
        if (!resourcesMap.containsKey(resourceName)) {
            throw new NameNotFoundException("no resource with name '" + resourceName + "' has been registered yet");
        }
        resourcesMap.remove(resourceName);
    }
}

