/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.List;

public class ClassLoadingHelper {
    public static Object newProxyInstance(List classLoadersToTry, Class[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        Object ret = null;
        ClassLoader cl = (ClassLoader)classLoadersToTry.get(0);
        List remainingClassLoaders = classLoadersToTry.subList(1, classLoadersToTry.size());
        try {
            return Proxy.newProxyInstance(cl, interfaces, delegate);
        }
        catch (IllegalArgumentException someClassNotFound) {
            if (remainingClassLoaders.size() <= 0) {
                throw someClassNotFound;
            }
            ret = ClassLoadingHelper.newProxyInstance(remainingClassLoaders, interfaces, delegate);
            return ret;
        }
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException nf) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static URL loadResourceFromClasspath(Class clazz, String resourceName) {
        URL ret = null;
        ret = clazz.getResource(resourceName);
        if (ret == null) {
            ret = clazz.getResource("/" + resourceName);
        }
        return ret;
    }
}

