/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.diagnostics;

import com.atomikos.diagnostics.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PrintStreamConsole
implements Console {
    protected PrintStream printstream_ = null;
    private int level_ = 1;
    private DateFormat formatter_;

    public PrintStreamConsole(PrintStream printstream) {
        this.printstream_ = printstream;
        this.formatter_ = new SimpleDateFormat("yy-MM-dd hh:mm:ss,SSS");
    }

    private synchronized void printLineSuffix() throws IOException {
        StringBuffer buf = new StringBuffer();
        Thread current = Thread.currentThread();
        String tName = current.getName();
        buf.append(this.formatter_.format(new Date()));
        buf.append(" [" + tName + "]");
        this.printstream_.print(buf.toString());
    }

    public synchronized void println(String string) throws IOException {
        this.printLineSuffix();
        this.print(string);
        this.printstream_.println();
    }

    public synchronized void print(String string) throws IOException {
        this.printstream_.print(string);
    }

    public void close() throws IOException {
        this.printstream_.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public void println(String string, int level) throws IOException {
        if (this.getLevel() >= level) {
            this.println(string);
        }
    }

    public void print(String string, int level) throws IOException {
        if (this.getLevel() >= level) {
            this.print(string);
        }
    }

    public void setLevel(int level) {
        this.level_ = level;
    }

    public int getLevel() {
        return this.level_;
    }
}

