/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import com.atomikos.util.IOHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class JarArchive {
    private File stageFolder_;

    public JarArchive(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IOException("Not a directory");
        }
        if (file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            file.mkdir();
        }
        this.stageFolder_ = file;
    }

    public File getStageFolder() {
        return this.stageFolder_;
    }

    protected void add(File file, File file2) throws IOException {
        if (file.getName().startsWith(".")) {
            return;
        }
        boolean bl = false;
        System.out.println("Adding file: " + IOHelper.getDifferencePath(this.stageFolder_, file));
        File file3 = new File(file2, IOHelper.getDifferencePath(this.stageFolder_, file));
        if (!file3.exists() && !(bl = IOHelper.createPathTo(file3, file.isDirectory()))) {
            throw new IOException("Could not create copy: " + file.getName());
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                this.add(fileArray[i], file3);
            }
        } else {
            System.out.println("Copying: " + file.getPath() + " to " + file3.getPath());
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            IOHelper.copyBytes(fileInputStream, fileOutputStream);
            fileInputStream.close();
            fileOutputStream.close();
        }
    }

    public void add(File file) throws IOException {
        if (file.getName().startsWith(".")) {
            return;
        }
        this.add(file, this.stageFolder_);
    }

    public void addToMetaInf(File file) throws IOException {
        File file2 = new File(this.stageFolder_, "META-INF");
        file2.mkdir();
        File file3 = new File(file2, file.getName());
        file3.createNewFile();
        file3.deleteOnExit();
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file3);
        IOHelper.copyBytes(fileInputStream, fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public void addJar(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            File file2 = new File(this.stageFolder_, jarEntry.getName());
            if (jarEntry.isDirectory()) {
                file2.mkdir();
            } else {
                file2.createNewFile();
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                IOHelper.copyBytes(inputStream, fileOutputStream);
                inputStream.close();
                ((OutputStream)fileOutputStream).close();
            }
            file2.deleteOnExit();
        }
    }

    public File createJar(String string, File file) throws IOException {
        File file2 = new File(file, string);
        if (!file2.exists()) {
            file2.createNewFile();
        }
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file2));
        File[] fileArray = this.stageFolder_.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            this.addEntryToJar(jarOutputStream, fileArray[i]);
        }
        jarOutputStream.close();
        return file2;
    }

    protected void addEntryToJar(JarOutputStream jarOutputStream, File file) throws IOException {
        JarEntry jarEntry = new JarEntry(IOHelper.getRelativePath(this.stageFolder_, file));
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                this.addEntryToJar(jarOutputStream, file2);
            }
        } else {
            jarOutputStream.putNextEntry(jarEntry);
            FileInputStream fileInputStream = new FileInputStream(file);
            IOHelper.copyBytes(fileInputStream, jarOutputStream);
            fileInputStream.close();
        }
    }
}

