/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOHelper {
    public static void copyBytes(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        int n = inputStream.read(byArray);
        while (n >= 0) {
            outputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
    }

    public static String getRelativePath(File file, File file2) throws IOException {
        String string = file.getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        if (!string2.startsWith(string)) {
            throw new IOException("The specified file is not within the folder.");
        }
        return string2.substring(string.length() + 1);
    }

    public static String getDifferencePath(File file, File file2) throws IOException {
        String string = file.getParentFile().getAbsolutePath();
        String string2 = file2.getAbsolutePath();
        if (!string2.startsWith(string)) {
            throw new IOException("The file should be contained in the parent directory of the stage folder.");
        }
        return string2.substring(string.length() + 1);
    }

    public static boolean createPathTo(File file, boolean bl) throws IOException {
        boolean bl2 = false;
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            IOHelper.createPathTo(file2, true);
        }
        bl2 = bl ? file.mkdir() : file.createNewFile();
        return bl2;
    }

    public static boolean deleteContents(File file) throws IOException {
        boolean bl = true;
        if (!file.isDirectory()) {
            throw new IOException("Not a directory");
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                if (IOHelper.deleteContents(fileArray[i])) continue;
                bl = false;
                continue;
            }
            if (fileArray[i].delete()) continue;
            bl = false;
        }
        return bl;
    }
}

