/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.swing;

import com.atomikos.swing.PropertiesTableModel;
import com.atomikos.swing.PropertyListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PropertiesPanel
implements ActionListener {
    private static final int NONE_SELECTED = -1;
    private JPanel panel_ = new JPanel();
    private JButton newButton_;
    private JButton deleteButton_;
    private JButton editButton_;
    private PropertiesTableModel model_;
    private Vector listeners_;
    private int currentRow_;

    public PropertiesPanel(PropertiesTableModel propertiesTableModel) {
        this(propertiesTableModel, false);
    }

    public PropertiesPanel(PropertiesTableModel propertiesTableModel, boolean bl) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.atomikos.swing.PropertiesPanelResourceBundle");
        this.panel_.setLayout(new BorderLayout());
        JTable jTable = new JTable(propertiesTableModel.getTableModel());
        Dimension dimension = new Dimension(200, 90);
        jTable.setPreferredScrollableViewportSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.panel_.add((Component)jScrollPane, "Center");
        this.model_ = propertiesTableModel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.newButton_ = new JButton(resourceBundle.getString("newButtonName"));
        this.newButton_.addActionListener(this);
        this.deleteButton_ = new JButton(resourceBundle.getString("deleteButtonName"));
        this.deleteButton_.setEnabled(false);
        this.deleteButton_.addActionListener(this);
        if (!bl) {
            jPanel.add(this.newButton_);
            jPanel.add(this.deleteButton_);
            this.editButton_ = new JButton(resourceBundle.getString("editButtonName"));
        } else {
            this.editButton_ = new JButton(resourceBundle.getString("viewButtonName"));
        }
        this.editButton_.setEnabled(false);
        this.editButton_.addActionListener(this);
        jPanel.add(this.editButton_);
        this.panel_.add((Component)jPanel, "South");
        this.listeners_ = new Vector();
        this.currentRow_ = -1;
        jTable.setSelectionMode(0);
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    PropertiesPanel.this.currentRow_ = -1;
                    PropertiesPanel.this.editButton_.setEnabled(false);
                    PropertiesPanel.this.deleteButton_.setEnabled(false);
                } else {
                    PropertiesPanel.this.currentRow_ = listSelectionModel.getMinSelectionIndex();
                    PropertiesPanel.this.editButton_.setEnabled(true);
                    PropertiesPanel.this.deleteButton_.setEnabled(true);
                }
            }
        });
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        int n = -1;
        if (actionEvent.getSource() == this.newButton_) {
            n = 0;
        } else if (actionEvent.getSource() == this.editButton_) {
            n = 1;
        } else if (actionEvent.getSource() == this.deleteButton_) {
            n = 2;
        }
        Enumeration enumeration = this.listeners_.elements();
        block5: while (enumeration.hasMoreElements()) {
            PropertyListener propertyListener = (PropertyListener)enumeration.nextElement();
            switch (n) {
                case 0: {
                    propertyListener.newProperty(this.model_);
                    continue block5;
                }
                case 1: {
                    propertyListener.editProperty(this.model_, this.currentRow_);
                    continue block5;
                }
                case 2: {
                    propertyListener.deleteProperty(this.model_, this.currentRow_);
                    this.deleteButton_.setEnabled(false);
                    this.editButton_.setEnabled(false);
                    continue block5;
                }
            }
        }
    }

    public synchronized void addPropertyListener(PropertyListener propertyListener) {
        this.listeners_.addElement(propertyListener);
    }

    public synchronized void removePropertyListener(PropertyListener propertyListener) {
        this.listeners_.remove(propertyListener);
    }

    public JPanel getPanel() {
        return this.panel_;
    }
}

