/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlFrame
implements HyperlinkListener,
ActionListener {
    private JFrame win_;
    private JEditorPane pane_ = new JEditorPane();
    private Stack stack_;
    private JButton back_;
    private URL lastUrl_;
    private JDialog dialog_;

    public HtmlFrame(URL uRL, JFrame jFrame) throws IOException {
        JScrollPane jScrollPane = new JScrollPane(this.pane_);
        this.pane_.setEditable(false);
        this.pane_.setPage(uRL);
        this.pane_.addHyperlinkListener(this);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Back24.gif"));
        this.back_ = new JButton(imageIcon);
        this.back_.setEnabled(false);
        this.back_.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.back_);
        this.stack_ = new Stack();
        this.lastUrl_ = uRL;
        if (jFrame == null) {
            this.win_ = new JFrame("HtmlViewer");
            this.win_.getContentPane().setLayout(new BorderLayout());
            this.win_.getContentPane().add((Component)jScrollPane, "Center");
            this.win_.getContentPane().add((Component)jPanel, "North");
            this.win_.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            Dimension dimension = new Dimension(600, 700);
            this.win_.setSize(dimension);
            this.win_.setVisible(true);
        } else {
            this.win_ = jFrame;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jScrollPane, "Center");
            jPanel2.add((Component)jPanel, "North");
            jPanel2.setSize(new Dimension(500, 500));
            JDialog jDialog = new JDialog(jFrame, "HtmlViewer", true);
            jDialog.setContentPane(jPanel2);
            jDialog.pack();
            jDialog.setSize(new Dimension(500, 500));
            jDialog.setVisible(true);
            this.dialog_ = jDialog;
        }
    }

    private void setWaitCursor(boolean bl) {
        Cursor cursor = null;
        cursor = bl ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0);
        if (this.dialog_ != null) {
            this.dialog_.getContentPane().setCursor(cursor);
        } else {
            this.win_.getContentPane().setCursor(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL uRL, boolean bl) {
        try {
            this.setWaitCursor(true);
            this.pane_.setPage(uRL);
            if (bl) {
                this.stack_.push(this.lastUrl_);
                this.back_.setEnabled(true);
            }
            this.lastUrl_ = uRL;
        }
        catch (IOException iOException) {
            System.err.println("Bad URL: " + uRL);
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL uRL = hyperlinkEvent.getURL();
            this.load(uRL, true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.back_) {
            this.load((URL)this.stack_.pop(), false);
            if (this.stack_.empty()) {
                this.back_.setEnabled(false);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: specify the URL to load");
            System.exit(1);
        }
        try {
            HtmlFrame htmlFrame = new HtmlFrame(new URL(stringArray[0]), null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

