/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.beans;

import com.atomikos.beans.IndexedPropertyImp;
import com.atomikos.beans.Property;
import com.atomikos.beans.PropertyException;
import com.atomikos.beans.PropertyImp;
import com.atomikos.beans.ReadOnlyException;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class BeanInspector {
    private Object bean_;

    public BeanInspector(Object object) {
        this.bean_ = object;
    }

    public Property[] getProperties() throws PropertyException {
        Property[] propertyArray = null;
        try {
            PropertyDescriptor[] propertyDescriptorArray;
            Class<?> clazz = this.bean_.getClass();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null && (propertyDescriptorArray = beanInfo.getPropertyDescriptors()) != null) {
                propertyArray = new Property[propertyDescriptorArray.length];
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    if (propertyDescriptorArray[i] instanceof IndexedPropertyDescriptor) {
                        IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptorArray[i];
                        propertyArray[i] = new IndexedPropertyImp(this.bean_, indexedPropertyDescriptor);
                        continue;
                    }
                    propertyArray[i] = new PropertyImp(this.bean_, propertyDescriptorArray[i]);
                }
            }
        }
        catch (Exception exception) {
            throw new PropertyException("Error getting properties", exception);
        }
        return propertyArray;
    }

    public Property getProperty(String string) throws PropertyException {
        Property property = null;
        Property[] propertyArray = this.getProperties();
        if (propertyArray != null) {
            for (int i = 0; i < propertyArray.length; ++i) {
                if (!propertyArray[i].getName().equals(string)) continue;
                property = propertyArray[i];
            }
        }
        return property;
    }

    public Object getBean() {
        return this.bean_;
    }

    public void setPropertyValue(String string, String string2) throws ReadOnlyException, PropertyException {
        Property property = this.getProperty(string);
        if (property == null) {
            throw new PropertyException("No such property: " + string);
        }
        property.getEditor().setStringValue(string2);
        property.setValue(property.getEditor().getEditedObject());
    }

    public String getPropertyValue(String string) throws PropertyException {
        String string2 = "";
        Property property = this.getProperty(string);
        Object object = property.getValue();
        if (object != null) {
            string2 = object.toString();
        }
        return string2;
    }
}

