package com.atlassian.webhooks;

import javax.annotation.Nonnull;
import java.util.Optional;

/**
 * Credentials for authenticated webhook URLs.
 *
 * @since 7.1
 */
public interface WebhookCredentials {

    /**
     * @return the password for the authenticated webhook URL, or {@link Optional#empty()} if it does not exist
     */
    @Nonnull
    Optional<String> getPassword();

    /**
     * @return the username for the authenticated webhook URL, or {@link Optional#empty()} if it does not exist
     */
    @Nonnull
    Optional<String> getUsername();
}
