package com.atlassian.web.servlet.api;

import javax.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.Optional;

/**
 * Authorizes forwards.
 *
 * @since 2.1.0
 */
public interface ForwardAuthorizer {

    /**
     * Authorizes a forward location.
     *
     * @param source the request being forwarded
     * @param target the servlet-container-relative target location
     * @return true when allowed; false when forbidden; absent when unknown
     * @since 4.0.0
     */
    Optional<Boolean> authorizeForward(HttpServletRequest source, URI target);
}

