package com.atlassian.vcache.internal;

import javax.annotation.Nonnull;
import java.util.Map;

/**
 * The management interface that contains methods to obtain information and manage the caches.
 *
 * @since 1.0
 */
public interface VCacheManagement {
    @Nonnull
    Map<String, JvmCacheDetails> allJvmCacheDetails();

    @Nonnull
    Map<String, RequestCacheDetails> allRequestCacheDetails();

    @Nonnull
    Map<String, ExternalCacheDetails> allExternalCacheDetails();

    // TODO: Add support for management of the caches. Specifically:
    // - ability to clear JvmCache and ExternalCache
}
