package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

import java.time.Duration;
import java.util.Set;

/**
 * Interface that defines the JVM cache operations.
 * <p>Notes:</p>
 * <ul>
 * <li>{@code null} keys and values are <b>NOT</b> supported</li>
 * <li>keys and values are stored by reference</li>
 * </ul>
 * <h1>Notes</h1>
 * <ul>
 * <li>
 * A cache has an associated time-to-live (<tt>ttl</tt>), which is expressed as {@link Duration}.
 * The implementations may round-up the supplied ttl to the nearest second. E.g. 500 milliseconds may be
 * converted to 1 second.
 * </li>
 * <li>
 * Do not assume that the associated ttl defines exactly when entries are evicted. The implementation is free
 * to choose how the ttl is interpreted. It may expire entries in a timely manner, or it may be delayed until
 * next interaction with the cache.
 * </li>
 * </ul>
 *
 * @param <K> the key type
 * @param <V> the value type
 * @since 1.0
 */
@PublicApi
public interface JvmCache<K, V> extends VCache, LocalCacheOperations<K, V> {
    /**
     * Gets the keys of all objects currently stored in the cache. This will return the keys in a new mutable set.
     *
     * @return a set of {@link Object}s keys
     */
    Set<K> getKeys();
}
