/**
 * Contains the core types for Atlassian VCache API. This API is independent of the Atlassian Cache API.
 * <p>
 * Three types of caches are supported:
 * </p>
 * <ul>
 * <li>
 * {@link com.atlassian.vcache.JvmCache} which is intended to hold data within the JVM. It
 * similar to the local version of the Atlassian Cache v2 {code Cache}. Use of these caches is discouraged,
 * and caching implementations may decide to restrict the creation of this type of cache (e.g. through
 * maintaining white-lists).
 * </li>
 * <li>
 * {@link com.atlassian.vcache.RequestCache} which is intended to hold data for the life of a request,
 * where a request is a unit-of-work as managed by the host application. Examples may be be a web request,
 * a scheduled job or a background task).
 * </li>
 * <li>
 * {@link com.atlassian.vcache.ExternalCache} which is intended to hold partitioned data externally
 * to the JVM. How the data is partitioned is dependant on the host application, so refer to the relevant
 * documentation. As an example, a host application that supports multi-tenancy may partition data by tenant.
 * </li>
 * </ul>
 *
 * @since 1.0
 */
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
package com.atlassian.vcache;

import com.atlassian.annotations.nonnull.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;
