package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

import static java.util.Objects.requireNonNull;

/**
 * Settings for configuring a RequestCache.
 *
 * @since 1.13.0
 */
@PublicApi
public class RequestCacheSettings {

    private final ChangeRate changeRate;

    RequestCacheSettings(ChangeRate changeRate) {
        this.changeRate = requireNonNull(changeRate);
    }

    /**
     * Returns the expected change rate for this cache.
     *
     * @return The {@link ChangeRate}.
     */
    public ChangeRate getChangeRate() {
        return changeRate;
    }
}
