package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

/**
 * Represents a request scope cache, which is intended to hold data for the life of a request.
 * A request is a unit-of-work as managed by the host application. Examples may be be a web request,
 * a scheduled job or a background task).
 * <h1>Notes</h1>
 * <ul>
 * <li>{@code null} keys and values are <b>NOT</b> supported</li>
 * <li>keys and values are stored by reference</li>
 * <li>
 * Data held in a request scope cache is cleared at the end of the request, and will
 * never be accessible again. It is not possible to share a request scope cache across
 * multiple requests (use a {@link JvmCache} or {@link ExternalCache} instead).
 * </li>
 * </ul>
 *
 * @param <K> the key type
 * @param <V> the value type
 * @since 1.0.0
 */
@PublicApi
public interface RequestCache<K, V> extends VCache, LocalCacheOperations<K, V> {
}
