package com.atlassian.vcache.marshallers;

import com.atlassian.annotations.Internal;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;

import java.util.Arrays;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

/**
 * Implementation for the {@link Optional} class.
 * @param <T> the type held in the Optional.
 *
 * @since 1.3.0
 * @deprecated since 1.5.0. Use the Atlassian Marshalling API and implementations instead.
 */
@Internal
@Deprecated
class OptionalMarshaller<T> implements Marshaller<Optional<T>> {

    private final Marshaller<T> valueMarshaller;

    OptionalMarshaller(Marshaller<T> valueMarshaller) {
        this.valueMarshaller = requireNonNull(valueMarshaller);
    }

    @Override
    public byte[] marshall(Optional<T> obj) throws MarshallerException {
        if (!obj.isPresent()) {
            return new byte[] {0};
        }

        final byte[] valueBytes = valueMarshaller.marshall(obj.get());
        final byte[] resultBytes = new byte[valueBytes.length + 1];
        resultBytes[0] = 1;
        System.arraycopy(valueBytes, 0, resultBytes, 1, valueBytes.length);
        return resultBytes;
    }

    @Override
    public Optional<T> unmarshall(byte[] raw) throws MarshallerException {
        if (raw[0] == 0) {
            return Optional.empty();
        }

        final byte[] valueBytes = Arrays.copyOfRange(raw, 1, raw.length);

        return Optional.of(valueMarshaller.unmarshall(valueBytes));
    }
}
