package com.atlassian.vcache;

import com.atlassian.annotations.PublicApi;

import java.util.Arrays;

/**
 * Represents the buffered write operations on an {@link ExternalCache}. The write operations are replayed at the
 * end of the request.
 *
 * @param <V> the value type
 * @since 1.0
 */
@PublicApi
public interface ExternalWriteOperationsBuffered<V> {
    /**
     * Puts the value under the specified key using the specified policy.
     *
     * @param key    the key to put the data under
     * @param value  the value to associate with the key.
     * @param policy the policy to apply
     */
    void put(String key, V value, PutPolicy policy);

    /**
     * Remove the entries with the specified keys.
     *
     * @param keys the keys of the entries to remove.
     */
    @SuppressWarnings("unchecked")
    default void remove(String... keys) {
        remove(Arrays.asList(keys));
    }

    /**
     * Remove the entries with the specified keys.
     *
     * @param keys the keys of the entries to remove.
     */
    void remove(Iterable<String> keys);

    /**
     * Remove all entries in the cache.
     */
    void removeAll();
}
