package com.atlassian.utils.process;

/**
 * A base implementation of the {@link OutputHandler} interface which maintains a reference to the {@link Watchdog}.
 */
public abstract class BaseOutputHandler implements OutputHandler {

    private Watchdog watchdog;

    public void complete() throws ProcessException {
    }

    public void setWatchdog(Watchdog watchdog) {
        this.watchdog = watchdog;
    }

    protected void cancelProcess() {
        watchdog.cancel();
    }

    /**
     * Retrieves a flag indicating whether the underlying process has been canceled.
     *
     * @return {@code true} if the process has been canceled; otherwise, {@code false}
     * @since 1.5
     */
    protected boolean isCanceled() {
        return watchdog.isCanceled();
    }

    protected void resetWatchdog() {
        if (watchdog != null) {
            watchdog.resetWatchdog();
        }
    }
}
