/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExternalProcessSettings {
    private final Map<String, String> environment = new HashMap<String, String>();
    private final List<ProcessMonitor> monitors = new ArrayList<ProcessMonitor>();
    private List<String> command;
    private long executionTimeout;
    private long idleTimeout;
    private ProcessHandler processHandler;
    private File workingDirectory;
    private boolean useQuotesInBatArgumentsWorkaround;
    private boolean escapeInternalDoubleQuotesOnWindows = false;

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public List<ProcessMonitor> getMonitors() {
        return this.monitors;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public long getExecutionTimeout() {
        return this.executionTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public ProcessHandler getProcessHandler() {
        return this.processHandler;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public boolean hasEnvironment() {
        return !this.environment.isEmpty();
    }

    public boolean hasExecutionTimeout() {
        return this.executionTimeout > 0L;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeout > 0L;
    }

    public boolean isSuppressSpecialWindowsBehaviour() {
        return false;
    }

    public boolean isUseWindowsEncodingWorkaround() {
        return false;
    }

    public void setCommand(List<String> command) {
        this.command = command;
    }

    public void setExecutionTimeout(long executionTimeout) {
        this.executionTimeout = executionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setProcessHandler(ProcessHandler processHandler) {
        this.processHandler = processHandler;
    }

    public void setSuppressSpecialWindowsBehaviour(boolean suppressSpecialWindowsBehaviour) {
    }

    public void setUseWindowsEncodingWorkaround(boolean useWindowsEncodingWorkaround) {
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setUseQuotesInBatArgumentsWorkaround(boolean useQuotesInBatArgumentsWorkaround) {
        this.useQuotesInBatArgumentsWorkaround = useQuotesInBatArgumentsWorkaround;
    }

    public boolean isUseQuotesInBatArgumentsWorkaround() {
        return this.useQuotesInBatArgumentsWorkaround;
    }

    public void validate() {
        if (this.command == null || this.command.isEmpty()) {
            throw new IllegalStateException("A command is required");
        }
        if (this.processHandler == null) {
            throw new IllegalStateException("A ProcessHandler is required");
        }
    }

    public boolean isEscapeInternalDoubleQuotesOnWindows() {
        return this.escapeInternalDoubleQuotesOnWindows;
    }

    public void setEscapeInternalDoubleQuotesOnWindows(boolean escapeInternalDoubleQuotesOnWindows) {
        this.escapeInternalDoubleQuotesOnWindows = escapeInternalDoubleQuotesOnWindows;
    }
}

