/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.IOUtils;
import com.atlassian.utils.process.ProcessException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;

public class StringOutputHandler
extends BaseOutputHandler {
    private final String encoding;
    private final StringWriter sw = new StringWriter();

    public StringOutputHandler() {
        this(null);
    }

    public StringOutputHandler(String encoding) {
        this.encoding = encoding;
    }

    public void process(InputStream output) throws ProcessException {
        try {
            int num;
            InputStreamReader reader = this.encoding == null ? new InputStreamReader(output) : new InputStreamReader(output, this.encoding);
            char[] buffer = new char[1024];
            while ((num = reader.read(buffer)) != -1) {
                this.resetWatchdog();
                this.sw.write(buffer, 0, num);
            }
        }
        catch (InterruptedIOException e) {
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    public String getOutput() {
        return this.sw.toString();
    }

    public void complete() {
        IOUtils.closeQuietly(this.sw);
    }
}

