/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.LatchedRunnable;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.ProcessTimeoutException;
import com.atlassian.utils.process.ProcessUtils;
import com.atlassian.utils.process.Watchdog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jvnet.winp.WinProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalProcess
implements Watchdog {
    private static final Logger log = Logger.getLogger(ExternalProcess.class);
    private static final String OS_NAME = System.getProperty("os.name");
    private boolean useWindowsEncodingWorkaround = false;
    private List<String> command;
    private File workingDir;
    private Map<String, String> environment;
    private ProcessHandler handler;
    private Process process;
    private final List<ProcessMonitor> monitors = new ArrayList<ProcessMonitor>();
    private ProcessException processException;
    private LatchedRunnable outputPump;
    private LatchedRunnable errorPump;
    private LatchedRunnable inputPump;
    private static final ExecutorService pumpThreadPool;
    private long lastWatchdogReset;
    private long timeout = 60000L;
    private Long startTime;
    private boolean cancelled;

    @Override
    public void resetWatchdog() {
        this.lastWatchdogReset = System.currentTimeMillis();
    }

    public long getTimeoutTime() {
        return this.lastWatchdogReset + this.timeout;
    }

    public boolean isTimedOut() {
        return this.getTimeoutTime() < System.currentTimeMillis();
    }

    public ExternalProcess(String[] command, ProcessHandler handler) {
        this.setCommand(Arrays.asList(command));
        this.setHandler(handler);
    }

    public ExternalProcess(List<String> command, ProcessHandler handler) {
        this.setCommand(command);
        this.setHandler(handler);
    }

    public ExternalProcess(String commandLine, ProcessHandler handler) {
        String[] cmdArray = ProcessUtils.tokenizeCommand(commandLine);
        this.setCommand(Arrays.asList(cmdArray));
        this.setHandler(handler);
    }

    private void setHandler(ProcessHandler handler) {
        this.handler = handler;
    }

    private void setCommand(List<String> command) {
        this.command = command;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    private boolean arePumpsRunning() {
        return this.outputPump.isRunning() || this.errorPump.isRunning() || this.inputPump != null && this.inputPump.isRunning();
    }

    public void setUseWindowsEncodingWorkaround(boolean useWindowsEncodingWorkaround) {
        this.useWindowsEncodingWorkaround = useWindowsEncodingWorkaround;
    }

    public ProcessHandler getHandler() {
        return this.handler;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void addMonitor(ProcessMonitor monitor) {
        this.monitors.add(monitor);
    }

    public void removeMonitor(ProcessMonitor monitor) {
        this.monitors.remove(monitor);
    }

    private boolean isWindows() {
        return OS_NAME.toLowerCase().contains("windows");
    }

    private String quoteString(String value) {
        StringBuilder builder = new StringBuilder().append("\"").append(value.replace("\"", "\\\"")).append("\"");
        return builder.toString();
    }

    private Process createWinProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        ArrayList<String> newCommand = new ArrayList<String>();
        newCommand.add("cmd");
        newCommand.add("/A");
        newCommand.add("/C");
        newCommand.add("call");
        if (this.useWindowsEncodingWorkaround) {
            HashMap<String, String> newEnv = environment != null ? new HashMap<String, String>(environment) : new HashMap();
            for (int counter = 1; counter < command.size(); ++counter) {
                String envName = "JENV_" + counter;
                newCommand.add("%" + envName + "%");
                newEnv.put(envName, this.quoteString(command.get(counter)));
            }
            environment = newEnv;
        } else {
            newCommand.addAll(command);
        }
        ProcessBuilder pb = new ProcessBuilder(newCommand);
        pb.directory(workingDir);
        if (environment != null) {
            pb.environment().putAll(environment);
        }
        if (log.isDebugEnabled()) {
            this.logProcessDetails(pb);
        }
        return pb.start();
    }

    private Process createProcess(List<String> command, Map<String, String> environment, File workingDir) throws IOException {
        if (this.isWindows()) {
            return this.createWinProcess(command, environment, workingDir);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(command).directory(workingDir);
        if (environment != null) {
            processBuilder.environment().putAll(environment);
        }
        if (log.isDebugEnabled()) {
            this.logProcessDetails(processBuilder);
        }
        return processBuilder.start();
    }

    private void logProcessDetails(ProcessBuilder processBuilder) {
        String divider = "---------------------------";
        log.debug((Object)divider);
        log.debug((Object)"Start Process Debug Information");
        log.debug((Object)divider);
        log.debug((Object)"Command");
        log.debug(processBuilder.command());
        log.debug((Object)divider);
        log.debug((Object)"Working Dir");
        log.debug((Object)processBuilder.directory());
        log.debug((Object)divider);
        log.debug((Object)"Environment");
        for (Map.Entry<String, String> entry : processBuilder.environment().entrySet()) {
            log.debug((Object)(entry.getKey() + ": " + entry.getValue()));
        }
        log.debug((Object)divider);
        log.debug((Object)"Redirect Error Stream?");
        log.debug((Object)processBuilder.redirectErrorStream());
        log.debug((Object)divider);
        log.debug((Object)"End Process Debug Information");
        log.debug((Object)divider);
    }

    public void start() {
        try {
            this.startTime = System.currentTimeMillis();
            this.process = this.createProcess(this.command, this.environment, this.workingDir);
            this.setupIOPumps();
        }
        catch (IOException e) {
            this.processException = new ProcessException(e);
        }
    }

    private void setupIOPumps() {
        if (this.handler.hasInput()) {
            this.inputPump = new LatchedRunnable("inputPump"){

                protected void doTask() {
                    ExternalProcess.this.handler.provideInput(ExternalProcess.this.process.getOutputStream());
                }
            };
        }
        this.errorPump = new LatchedRunnable("errorPump"){

            protected void doTask() {
                try {
                    ExternalProcess.this.handler.processError(ExternalProcess.this.process.getErrorStream());
                }
                catch (Throwable e) {
                    if (!this.isCancelled()) {
                        log.debug((Object)(this.name + ": Process wasn't cancelled, storing exception"), e);
                        ExternalProcess.this.processException = new ProcessException(e);
                    }
                    log.debug((Object)(this.name + ": Process cancelled ignoring exception"), e);
                }
            }
        };
        this.outputPump = new LatchedRunnable("outputPump"){

            protected void doTask() {
                try {
                    ExternalProcess.this.handler.processOutput(ExternalProcess.this.process.getInputStream());
                }
                catch (Throwable e) {
                    if (!this.isCancelled()) {
                        log.debug((Object)(this.name + ": Process wasn't cancelled, storing exception"), e);
                        ExternalProcess.this.processException = new ProcessException(e);
                    }
                    log.debug((Object)(this.name + ": Process cancelled ignoring exception"), e);
                }
            }
        };
        this.resetWatchdog();
        this.handler.setWatchdog(this);
        pumpThreadPool.execute(this.errorPump);
        pumpThreadPool.execute(this.outputPump);
        if (this.inputPump != null) {
            pumpThreadPool.execute(this.inputPump);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this.process != null) {
            try {
                do {
                    long checkTime = this.getTimeoutTime();
                    this.awaitPump(this.outputPump, checkTime);
                    this.awaitPump(this.inputPump, checkTime);
                    this.awaitPump(this.errorPump, checkTime);
                } while (!this.isTimedOut() && this.arePumpsRunning() && !Thread.currentThread().isInterrupted());
            }
            finally {
                if (Thread.currentThread().isInterrupted()) {
                    this.cancel();
                    Thread.interrupted();
                }
                int exitCode = this.wrapUpProcess();
                this.handler.complete(exitCode, this.processException);
            }
        } else {
            this.handler.complete(-1, this.processException);
        }
    }

    private void notifyBeforeStart() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onBeforeStart(this);
            }
            catch (Exception e) {
                Logger.getLogger(ExternalProcess.class).error((Object)"Error while processing 'beforeStarted' event:", (Throwable)e);
            }
        }
    }

    private void notifyAfterFinished() {
        for (ProcessMonitor monitor : this.monitors) {
            try {
                monitor.onAfterFinished(this);
            }
            catch (Exception e) {
                Logger.getLogger(ExternalProcess.class).error((Object)"Error while processing 'afterFinished' event:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        this.notifyBeforeStart();
        try {
            this.start();
            this.finish();
        }
        finally {
            this.notifyAfterFinished();
        }
    }

    public void executeWhile(Runnable runnable) {
        this.start();
        if (runnable != null) {
            runnable.run();
        }
        this.finish();
    }

    public String getCommandLine() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.command) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finish(int maxWait) {
        if (this.process != null) {
            boolean finished = false;
            try {
                long endTime = System.currentTimeMillis() + (long)maxWait;
                this.awaitPump(this.outputPump, endTime);
                this.awaitPump(this.inputPump, endTime);
                this.awaitPump(this.errorPump, endTime);
            }
            finally {
                if (!this.arePumpsRunning()) {
                    finished = true;
                    int exitCode = this.wrapUpProcess();
                    this.handler.complete(exitCode, this.processException);
                }
            }
            return finished;
        }
        this.handler.complete(-1, this.processException);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrapUpProcess() {
        int exitCode = -1;
        boolean processIncomplete = true;
        boolean interrupted = false;
        try {
            exitCode = this.process.exitValue();
            processIncomplete = false;
        }
        catch (IllegalThreadStateException e) {
            while (processIncomplete && System.currentTimeMillis() - this.getTimeoutTime() < 10L) {
                try {
                    Thread.sleep(100L);
                    exitCode = this.process.exitValue();
                    processIncomplete = false;
                }
                catch (InterruptedException e1) {
                    processIncomplete = true;
                    interrupted = true;
                    break;
                }
                catch (IllegalThreadStateException e2) {
                }
            }
        }
        finally {
            this.cancel();
        }
        if (processIncomplete && !interrupted) {
            this.processException = new ProcessTimeoutException("process timed out");
        }
        return exitCode;
    }

    private void awaitPump(LatchedRunnable runnable, long latestTime) {
        if (runnable != null) {
            long timeout = latestTime - System.currentTimeMillis();
            if (timeout < 1L) {
                timeout = 1L;
            }
            runnable.await(timeout);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        if (this.outputPump != null) {
            this.outputPump.cancel();
        }
        if (this.inputPump != null) {
            this.inputPump.cancel();
        }
        if (this.errorPump != null) {
            this.errorPump.cancel();
        }
        if (this.process != null) {
            if (this.isWindows()) {
                try {
                    WinProcess winProcess = new WinProcess(this.process);
                    winProcess.killRecursively();
                }
                catch (Throwable e) {
                    log.error((Object)"Could not recursively kill windows process using winp; falling back to java.lang.Process#destroy", e);
                    this.process.destroy();
                }
            } else {
                this.process.destroy();
            }
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public static void shutdown() {
        if (pumpThreadPool != null) {
            pumpThreadPool.shutdown();
        }
    }

    static {
        ThreadFactory threadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "ExtProcess IO Pump");
            }
        };
        pumpThreadPool = new ThreadPoolExecutor(6, Integer.MAX_VALUE, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }
}

