/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.StringInputHandler;
import com.atlassian.utils.process.StringOutputHandler;

public class StringProcessHandler
extends PluggableProcessHandler {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private StringOutputHandler outputHandler;
    private StringOutputHandler errorHandler;

    public StringProcessHandler() {
        this(null, DEFAULT_ENCODING);
    }

    public StringProcessHandler(String input) {
        this(input, DEFAULT_ENCODING);
    }

    public StringProcessHandler(String input, String encoding) {
        if (input != null) {
            this.setInputHandler(new StringInputHandler(encoding, input));
        }
        this.outputHandler = new StringOutputHandler(encoding);
        this.setOutputHandler(this.outputHandler);
        this.errorHandler = new StringOutputHandler(encoding);
        this.setErrorHandler(this.errorHandler);
    }

    public String getOutput() {
        return this.outputHandler.getOutput();
    }

    public String getError() {
        return this.errorHandler.getOutput();
    }
}

