/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;

public class PipedStreams {
    private final byte[] buffer;
    private final int moduloMask;
    private final PipedInputStream input;
    private final PipedOutputStream output;
    private volatile boolean closed;

    public PipedStreams(int bufferSize) {
        this.moduloMask = bufferSize - 1;
        if (bufferSize <= 0 || (bufferSize & this.moduloMask) != 0) {
            throw new IllegalArgumentException("Please choose a buffer size that is a power of two");
        }
        this.buffer = new byte[bufferSize];
        this.input = new PipedInputStream();
        this.output = new PipedOutputStream();
    }

    public InputStream input() {
        return this.input;
    }

    public OutputStream output() {
        return this.output;
    }

    public void close() {
        this.doClose();
    }

    private void doClose() {
        this.closed = true;
        this.input.unblock();
        this.output.unblock();
    }

    private int readBytesAvailable() {
        int ret = this.output.getWritePos() - this.input.getReadPos();
        return ret == 0 && this.closed ? -1 : ret;
    }

    private int writeBytesAvailable() throws IOException {
        if (this.closed) {
            throw new IOException("Write to closed pipe");
        }
        return this.input.getReadPos() + this.buffer.length - this.output.getWritePos();
    }

    private class PipedOutputStream
    extends OutputStream {
        private volatile int writePos = 0;
        private final Object sync = new Object();
        private final AtomicBoolean notifyRequired = new AtomicBoolean(false);

        @Override
        public void close() throws IOException {
            PipedStreams.this.doClose();
        }

        @Override
        public void write(int b) throws IOException {
            this.awaitSpace();
            int currentWritePos = this.writePos;
            ((PipedStreams)PipedStreams.this).buffer[currentWritePos & ((PipedStreams)PipedStreams.this).moduloMask] = (byte)b;
            this.writePos = currentWritePos + 1;
            PipedStreams.this.input.unblock();
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) throws IOException {
            int toWrite;
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException("off + len > b.length (" + off + " + " + len + " > " + b.length);
            }
            for (int written = 0; written < len; written += toWrite) {
                int bufferSize;
                int available = this.awaitSpace();
                int currentWritePos = this.writePos;
                int bufferWritePos = currentWritePos & PipedStreams.this.moduloMask;
                toWrite = Math.min(len - written, available);
                if (toWrite + bufferWritePos > (bufferSize = PipedStreams.this.buffer.length)) {
                    int bytesBeforeWrap = bufferSize - bufferWritePos;
                    System.arraycopy(b, written + off, PipedStreams.this.buffer, bufferWritePos, bytesBeforeWrap);
                    System.arraycopy(b, written + bytesBeforeWrap + off, PipedStreams.this.buffer, 0, toWrite - bytesBeforeWrap);
                } else {
                    System.arraycopy(b, written + off, PipedStreams.this.buffer, bufferWritePos, toWrite);
                }
                this.writePos = currentWritePos + toWrite;
                PipedStreams.this.input.unblock();
            }
        }

        private int getWritePos() {
            return this.writePos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unblock() {
            if (this.notifyRequired.getAndSet(false)) {
                Object object = this.sync;
                synchronized (object) {
                    this.sync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int awaitSpace() throws IOException {
            int ret = PipedStreams.this.writeBytesAvailable();
            if (ret == 0) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        while (true) {
                            this.notifyRequired.getAndSet(true);
                            ret = PipedStreams.this.writeBytesAvailable();
                            if (ret == 0) {
                                this.sync.wait();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
            return ret;
        }
    }

    private class PipedInputStream
    extends InputStream {
        private volatile int readPos = 0;
        private final Object sync = new Object();
        private final AtomicBoolean notifyRequired = new AtomicBoolean(false);

        private PipedInputStream() {
        }

        @Override
        public int available() throws IOException {
            return PipedStreams.this.output.getWritePos() - PipedStreams.this.input.getReadPos();
        }

        @Override
        public void close() throws IOException {
            PipedStreams.this.doClose();
        }

        @Override
        public int read() throws IOException {
            if (this.waitIfEmpty() == -1) {
                return -1;
            }
            int currentReadPos = this.readPos;
            int ret = PipedStreams.this.buffer[currentReadPos & PipedStreams.this.moduloMask] & 0xFF;
            this.readPos = currentReadPos + 1;
            PipedStreams.this.output.unblock();
            return ret;
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int availableBytes = this.waitIfEmpty();
            if (availableBytes == -1) {
                return -1;
            }
            int currentReadPos = this.readPos;
            int currentBufferReadPos = currentReadPos & PipedStreams.this.moduloMask;
            int toRead = Math.min(len, availableBytes);
            if (toRead + currentBufferReadPos > PipedStreams.this.buffer.length) {
                int bytesBeforeWrap = PipedStreams.this.buffer.length - currentBufferReadPos;
                System.arraycopy(PipedStreams.this.buffer, currentBufferReadPos, b, off, bytesBeforeWrap);
                System.arraycopy(PipedStreams.this.buffer, 0, b, off + bytesBeforeWrap, toRead - bytesBeforeWrap);
            } else {
                System.arraycopy(PipedStreams.this.buffer, currentBufferReadPos, b, off, toRead);
            }
            this.readPos = currentReadPos + toRead;
            PipedStreams.this.output.unblock();
            return toRead;
        }

        private int getReadPos() {
            return this.readPos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unblock() {
            if (this.notifyRequired.getAndSet(false)) {
                Object object = this.sync;
                synchronized (object) {
                    this.sync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int waitIfEmpty() throws IOException {
            int ret = PipedStreams.this.readBytesAvailable();
            if (ret == 0) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        while (true) {
                            this.notifyRequired.getAndSet(true);
                            ret = PipedStreams.this.readBytesAvailable();
                            if (ret == 0) {
                                this.sync.wait();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
            return ret;
        }
    }
}

