/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheEntryStatistics;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

class DefaultCacheEntryStatistics
implements CacheEntryStatistics {
    private final String cacheKey;
    private final Date createdDate;
    private final AtomicInteger hits;
    private volatile Date lastAccessedDate;
    private volatile long size;

    public DefaultCacheEntryStatistics(String cacheKey) {
        this.cacheKey = cacheKey;
        this.createdDate = new Date();
        this.hits = new AtomicInteger(0);
        this.lastAccessedDate = this.createdDate;
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.cacheKey;
    }

    @Override
    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Override
    @Nonnull
    public Date getLastAccessedDate() {
        return this.lastAccessedDate;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getHits() {
        return this.hits.get();
    }

    public void onCacheHit() {
        this.hits.incrementAndGet();
        this.lastAccessedDate = new Date();
    }

    public void setSize(long size) {
        this.size = size;
    }
}

