/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.RuntimeInterruptedException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ConcurrentOperationMapImpl<K, R>
implements ConcurrentOperationMap<K, R> {
    private final ConcurrentMap<K, FutureTask<R>> map = new ConcurrentHashMap<K, FutureTask<R>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R runOperation(K key, Callable<R> operation) throws ExecutionException {
        FutureTask future = (FutureTask)this.map.get(key);
        while (future == null) {
            this.map.putIfAbsent(key, new FutureTask<R>(operation));
            future = (FutureTask)this.map.get(key);
        }
        try {
            R r = this.runAndGet(future);
            return r;
        }
        finally {
            this.map.remove(key, future);
        }
    }

    R runAndGet(FutureTask<R> future) throws ExecutionException {
        future.run();
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw e;
        }
    }
}

