/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.BooleanLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BlockingReference<V> {
    private final AtomicReference<V> ref = new AtomicReference();
    private final BooleanLatch latch = new BooleanLatch();

    public V take() throws InterruptedException {
        V result;
        do {
            this.latch.await();
        } while ((result = this.ref.getAndSet(null)) == null);
        return result;
    }

    public V take(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.ref.getAndSet(null);
    }

    public void set(V value) {
        Assertions.notNull("value", value);
        this.ref.set(value);
        this.latch.release();
    }

    public boolean isEmpty() {
        return this.ref.get() == null;
    }
}

