UPM.define('UninstallDialog', [
    'UpmDialog',
    'UpmAnalytics'
], function (UpmDialog,
             UpmAnalytics) {

    'use strict';

    return UpmDialog.extend({

        template: com.atlassian.upm.application.uninstallConfirmDialog,

        _postShow: function () {
            UpmAnalytics.logEvent('manageapps-uninstall-show', { appKey: this.options.data.app.key });
        },

        _getReturnValue: function() {
            return {
                deleteLicenseAndConfig: this.$el.find('#delete-data').is(':checked')
            };
        },

        getResult: function () {
            var params = { appKey: this.options.data.app.key };
            return UpmDialog.prototype.getResult.apply(this)
                .done(function () {
                    UpmAnalytics.logEvent('manageapps-uninstall-submit', params);
                })
                .fail(function () {
                    UpmAnalytics.logEvent('manageapps-uninstall-cancel', params);
                });
        }
    });
});