/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.rest.resources;

import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseAdapter;
import com.atlassian.upm.application.utils.ClassUtils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class MultipleApplicationLicenseAdapterFactory {
    public static final String NO_APP_KEY = "no-app-key";
    private final LicenseHandler licenseHandler;
    private final LocaleResolver localeResolver;
    private final ClassUtils classUtils;

    public MultipleApplicationLicenseAdapterFactory(LicenseHandler licenseHandler, LocaleResolver localeResolver, ClassUtils classUtils) {
        this.licenseHandler = Objects.requireNonNull(licenseHandler);
        this.localeResolver = Objects.requireNonNull(localeResolver);
        this.classUtils = Objects.requireNonNull(classUtils);
    }

    public Optional<MultipleApplicationLicenseAdapter> getAdapter() {
        return this.classUtils.forName("com.atlassian.sal.api.license.RawProductLicense").map(c -> new MultipleApplicationLicenseAdapter(this.licenseHandler, this.localeResolver));
    }

    public static class LicenseUpdate {
        @JsonProperty
        private final String applicationKey;
        @JsonProperty
        private final String license;
        @JsonProperty
        private final boolean delete;

        @JsonCreator
        public LicenseUpdate(@JsonProperty(value="applicationKey") String applicationKey, @JsonProperty(value="license") String license, @JsonProperty(value="delete") boolean delete) {
            this.applicationKey = Objects.requireNonNull(applicationKey);
            this.license = Objects.requireNonNull(license);
            this.delete = delete;
        }

        @Nonnull
        public Optional<String> getProductKey() {
            return Optional.ofNullable(this.applicationKey);
        }

        @Nonnull
        public Optional<String> getLicense() {
            return Optional.ofNullable(this.license);
        }

        public boolean isDelete() {
            return this.delete;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LicenseUpdate that = (LicenseUpdate)o;
            return new EqualsBuilder().append(this.delete, that.delete).append((Object)this.applicationKey, (Object)that.applicationKey).append((Object)this.license, (Object)that.license).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.applicationKey).append((Object)this.license).append(this.delete).toHashCode();
        }
    }
}

