/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.ProductLicense;
import com.atlassian.upm.api.license.DataCenterCrossgradeablePlugins;
import com.atlassian.upm.application.LicenseMismatchDetector;
import com.atlassian.upm.application.rest.representations.LicenseMismatch;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LicenseMismatchDetectorImpl
implements LicenseMismatchDetector {
    public static final String JIRA_CORE = "jira-core";
    private final DataCenterCrossgradeablePlugins dataCenterCrossgradeablePlugins;
    private final LicenseHandler licenseHandler;

    public LicenseMismatchDetectorImpl(LicenseHandler licenseHandler, DataCenterCrossgradeablePlugins dataCenterCrossgradeablePlugins) {
        this.licenseHandler = Objects.requireNonNull(licenseHandler);
        this.dataCenterCrossgradeablePlugins = Objects.requireNonNull(dataCenterCrossgradeablePlugins);
    }

    @Override
    public Optional<LicenseMismatch> detectLicenseMismatch(Map<String, MultipleApplicationLicenseResponse.LicenseResult> errors, String newLicenseString, String newLicenseApplicationKey) {
        MultiProductLicenseDetails newDetails = this.licenseHandler.decodeLicenseDetails(newLicenseString);
        if (!newDetails.isDataCenter()) {
            return Optional.empty();
        }
        if (JIRA_CORE.equals(newLicenseApplicationKey)) {
            return Optional.empty();
        }
        if (this.shouldShowLicenseMismatchInformation(errors, newLicenseApplicationKey)) {
            Optional<ProductLicense> licenseToRemove = this.findLicenseToRemove(newDetails.isDataCenter());
            List otherApplicationLicenses = this.allServerProductLicenses().filter(pl -> !pl.getProductKey().equals(newLicenseApplicationKey) && !this.productMayNeedToBeRemoved((ProductLicense)pl)).collect(Collectors.toList());
            if (otherApplicationLicenses.size() > 1) {
                return Optional.empty();
            }
            Optional<ProductLicense> otherLicense = otherApplicationLicenses.stream().findFirst();
            Set newProductLicenses = newDetails.getProductLicenses();
            if (newProductLicenses.size() == 1) {
                ProductLicense newLicense = (ProductLicense)newProductLicenses.stream().findAny().get();
                return Optional.of(this.createLicenseMismatchData(newLicenseString, newLicenseApplicationKey, newDetails, newLicense, otherLicense, licenseToRemove));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private boolean shouldShowLicenseMismatchInformation(Map<String, MultipleApplicationLicenseResponse.LicenseResult> errors, String newLicenseApplicationKey) {
        List<DataCenterCrossgradeablePlugins.CrossgradePluginData> crossGradablePlugins = this.dataCenterCrossgradeablePlugins.getDataCenterLicenseCrossgradeablePlugins();
        List<MultipleApplicationLicenseResponse.LicenseError> errorList = errors.getOrDefault(newLicenseApplicationKey, new MultipleApplicationLicenseResponse.LicenseResult(Collections.emptyList(), Collections.emptyList())).getErrors();
        return errorList.stream().anyMatch(e -> e.getMismatchError() != null && e.getMismatchError() != false) || errorList.isEmpty() && !crossGradablePlugins.isEmpty();
    }

    private LicenseMismatch createLicenseMismatchData(String newLicenseString, String newLicenseApplicationKey, MultiProductLicenseDetails newDetails, ProductLicense newLicense, Optional<ProductLicense> otherLicense, Optional<ProductLicense> licenseToRemove) {
        return new LicenseMismatch(otherLicense.map(ProductLicense::getProductDisplayName).orElse(null), otherLicense.map(ProductLicense::getProductKey).orElse(null), newLicenseString, newLicense.getProductDisplayName(), newLicenseApplicationKey, newDetails.isDataCenter(), licenseToRemove.map(ProductLicense::getProductDisplayName).orElse(null), licenseToRemove.map(ProductLicense::getProductKey).orElse(null), licenseToRemove.map(l -> this.licenseHandler.getRawProductLicense(l.getProductKey())).orElse(null), this.createAppCrossgradeList(), newDetails.isEvaluationLicense() && !otherLicense.isPresent());
    }

    private List<LicenseMismatch.AppCrossgrade> createAppCrossgradeList() {
        return this.dataCenterCrossgradeablePlugins.getDataCenterLicenseCrossgradeablePlugins().stream().map(p -> new LicenseMismatch.AppCrossgrade(p.getName())).collect(Collectors.toList());
    }

    private Stream<ProductLicense> allServerProductLicenses() {
        return this.licenseHandler.getAllProductLicenses().stream().filter(l -> !l.isDataCenter()).flatMap(l -> l.getProductLicenses().stream());
    }

    private Optional<ProductLicense> findLicenseToRemove(boolean newIsDataCenter) {
        return this.licenseHandler.getAllProductLicenses().stream().filter(l -> l.getProductLicenses().stream().anyMatch(this::productMayNeedToBeRemoved) && l.isDataCenter() != newIsDataCenter).flatMap(l -> l.getProductLicenses().stream().filter(this::productMayNeedToBeRemoved)).findFirst();
    }

    private boolean productMayNeedToBeRemoved(ProductLicense productLicense) {
        return productLicense.getProductKey().equals(JIRA_CORE);
    }
}

