/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.application.rest.resources.AppUpdatesResource;
import com.atlassian.upm.application.rest.resources.ApplicationClearConfigResource;
import com.atlassian.upm.application.rest.resources.ApplicationLicenseResource;
import com.atlassian.upm.application.rest.resources.ApplicationResource;
import com.atlassian.upm.application.rest.resources.AvailableAppCollectionResource;
import com.atlassian.upm.application.rest.resources.MultipleApplicationLicenseResource;
import com.atlassian.upm.application.rest.resources.ScheduledBundledUpdatesResource;
import com.atlassian.upm.core.rest.CoreUriBuilder;
import com.atlassian.upm.core.test.rest.resources.BuildNumberResource;
import com.atlassian.upm.core.test.rest.resources.MpacBaseUrlResource;
import com.google.common.base.Function;
import io.atlassian.fugue.Option;
import java.net.URI;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;

public class ApplicationUriBuilder
extends CoreUriBuilder {
    private UserManager userManager;
    private LicenseHandler licenseHandler;

    public ApplicationUriBuilder(ApplicationProperties applicationProperties, UserManager userManager, LicenseHandler licenseHandler) {
        super(applicationProperties, "/rest/plugins/applications/1.0");
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.licenseHandler = Objects.requireNonNull(licenseHandler, "licenseHandler");
    }

    public final URI buildApplicationRestRoot() {
        return this.newPluginBaseUriBuilder().build(new Object[0]);
    }

    public final URI buildApplicationUri(ApplicationKey applicationKey) {
        return this.newPluginBaseUriBuilder().path(ApplicationResource.class).build(new Object[]{applicationKey.value()});
    }

    public final URI buildClearConfigurationUri(ApplicationKey applicationKey) {
        return this.newPluginBaseUriBuilder().path(ApplicationClearConfigResource.class).build(new Object[]{applicationKey.value()});
    }

    public final URI buildApplicationLicenseUri(ApplicationKey applicationKey) {
        return this.newPluginBaseUriBuilder().path(ApplicationLicenseResource.class).build(new Object[]{applicationKey.value()});
    }

    public final URI buildSetMultipleApplicationLicenseUri() {
        return this.newPluginBaseUriBuilder().path(MultipleApplicationLicenseResource.class).path("update").build(new Object[0]);
    }

    public final URI buildValidateMultipleApplicationLicenseUri() {
        return this.newPluginBaseUriBuilder().path(MultipleApplicationLicenseResource.class).path("validate").build(new Object[0]);
    }

    public final URI buildWacApplicationUpdateUri(ApplicationKey applicationKey) {
        return this.buildGoAtlassianUri("/versions-licenses-application-download-" + applicationKey.value());
    }

    public final URI buildApplicationAccessRoleManagementUri(ApplicationAccess access) {
        URI uri = access.getManagementPage();
        return this.newApplicationBaseUriBuilder().path(uri.getPath()).replaceQuery(uri.getQuery()).build(new Object[0]);
    }

    public final URI buildApplicationLicenseReceiptUri() {
        return this.makeAbsolute(this.newApplicationBaseUriBuilder().path("/plugins/servlet/applications/versions-licenses/add-licenses").build(new Object[0]));
    }

    public final URI buildApplicationEvalLicenseReceiptUri(ApplicationKey applicationKey) {
        return this.makeAbsolute(this.newApplicationBaseUriBuilder().path("/plugins/servlet/applications/versions-licenses/add-licenses/" + applicationKey.value() + "/evaluation").build(new Object[0]));
    }

    public final URI buildAppUpdatesUri() {
        return this.newPluginBaseUriBuilder().path(AppUpdatesResource.class).build(new Object[0]);
    }

    public final URI buildAvailableAppsUri() {
        return this.newPluginBaseUriBuilder().path(AvailableAppCollectionResource.class).build(new Object[0]);
    }

    public final URI buildBuildNumberUri() {
        return this.newPluginBaseUriBuilder().path(BuildNumberResource.class).build(new Object[0]);
    }

    public final URI buildManageAppsUri() {
        return this.makeAbsolute(this.newApplicationBaseUriBuilder().path("/plugins/servlet/applications/versions-licenses").build(new Object[0]));
    }

    public final URI buildMpacBaseUrlUri() {
        return this.newPluginBaseUriBuilder().path(MpacBaseUrlResource.class).build(new Object[0]);
    }

    public final URI buildPluginCollectionUri() {
        return this.newApplicationBaseUriBuilder().path("/rest/plugins/1.0/").build(new Object[0]);
    }

    public final URI buildScheduledBundledUpdatesUri() {
        return this.newPluginBaseUriBuilder().path(ScheduledBundledUpdatesResource.class).build(new Object[0]);
    }

    private UriBuilder buildShoppingCartUri(String type, String identifier) {
        return UriBuilder.fromUri((URI)URI.create(this.buildShoppingCartUri() + "/software/1/" + type + "/" + identifier)).queryParam("referrer", new Object[]{"manage-applications"}).queryParam("callback", new Object[]{this.buildApplicationLicenseReceiptUri().toASCIIString()}).queryParam("email", new Object[]{this.userManager.getRemoteUser().getEmail()});
    }

    public final URI buildPurchaseSoftwareUri(ApplicationKey applicationKey, int userCount) {
        return this.buildShoppingCartUri("buy", applicationKey.value()).queryParam("serverId", new Object[]{this.licenseHandler.getServerId()}).queryParam("unitCount", new Object[]{userCount}).queryParam("academic", new Object[]{this.isAcademic()}).build(new Object[0]);
    }

    private boolean isAcademic() {
        for (MultiProductLicenseDetails lic : this.licenseHandler.getAllProductLicenses()) {
            if (!lic.getLicenseTypeName().equalsIgnoreCase(LicenseType.ACADEMIC.name())) continue;
            return true;
        }
        return false;
    }

    public final URI buildRenewSoftwareUri(String sen) {
        return this.buildShoppingCartUri("renew", sen.replaceAll("SEN-", "")).build(new Object[0]);
    }

    public final URI buildUpgradeSoftwareUri(String sen) {
        return this.buildShoppingCartUri("upgrade", sen.replaceAll("SEN-", "")).build(new Object[0]);
    }

    public final URI buildUpmGlobalSettingsUri() {
        return this.makeAbsolute(this.newApplicationBaseUriBuilder().path("/plugins/servlet/upm/manage").fragment("settings").build(new Object[0]));
    }

    public final URI buildUpmBulkUninstallUri() {
        return this.makeAbsolute(this.newApplicationBaseUriBuilder().path("/rest/plugins/1.0/uninstall").build(new Object[0]));
    }

    public final URI buildAnalyticsUri() {
        return this.makeAbsolute(this.newApplicationBaseUriBuilder().path("/rest/plugins/1.0/analytics").build(new Object[0]));
    }

    public Option<URI> buildPostInstallUri(Application app) {
        return app.getPostInstallURI().map((java.util.function.Function)new Function<URI, URI>(){

            public URI apply(URI original) {
                return ApplicationUriBuilder.this.makeAbsolute(ApplicationUriBuilder.this.newApplicationBaseUriBuilder().path(original.getPath()).replaceQuery(original.getQuery()).build(new Object[0]));
            }
        });
    }

    public final Option<URI> buildPostUpdateUri(Application app) {
        return app.getPostUpdateURI().map((java.util.function.Function)new Function<URI, URI>(){

            public URI apply(URI original) {
                return ApplicationUriBuilder.this.makeAbsolute(ApplicationUriBuilder.this.newApplicationBaseUriBuilder().path(original.getPath()).replaceQuery(original.getQuery()).build(new Object[0]));
            }
        });
    }
}

