/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.test;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.mockito.Mockito;

public abstract class MockLicenses {
    public static final DateTime OLD_EXPIRED_DATE = new DateTime().minusDays(7).minusHours(1).minusSeconds(1);
    public static final DateTime NEWLY_EXPIRED_DATE = new DateTime().minusDays(1).plusHours(2);
    public static final DateTime SOON_TO_EXPIRE_DATE = new DateTime().plusDays(1);
    public static final DateTime IN_THE_FAR_FUTURE_EXPIRE_DATE = new DateTime().plusDays(31);
    public static final String PLUGIN_KEY = "my-plugin-key";
    public static final String LEGACY_LICENSED_PLUGIN_KEY = "com.atlassian.bonfire.plugin";
    public static PluginLicense oldExpiredEvaluationLicense;
    public static PluginLicense newlyExpiredEvaluationLicense;
    public static PluginLicense soonToExpireEvaluationLicense;
    public static PluginLicense inTheFarFutureExpireEvaluationLicense;
    public static PluginLicense userMismatchEvaluationLicense;
    public static PluginLicense oldMaintenanceExpiredNonEvaluationLicense;
    public static PluginLicense newlyMaintenanceExpiredNonEvaluationLicense;
    public static PluginLicense soonToMaintenanceExpireNonEvaluationLicense;
    public static PluginLicense inTheFarFutureMaintenanceExpireNonEvaluationLicense;
    public static PluginLicense userMismatchNonEvaluationLicense;
    public static PluginLicense editionMismatchNonEvaluationLicense;
    public static PluginLicense soonToMaintenanceExpireNonEvaluationLicenseForLegacyPlugin;
    public static PluginLicense inTheFarFutureMaintenanceExpireNonEvaluationDataCenterLicense;

    public static void initLicenses() {
        oldExpiredEvaluationLicense = MockLicenses.builder().evaluation(true).expiryDate((Option<DateTime>)Option.some((Object)OLD_EXPIRED_DATE)).build();
        newlyExpiredEvaluationLicense = MockLicenses.builder().evaluation(true).expiryDate((Option<DateTime>)Option.some((Object)NEWLY_EXPIRED_DATE)).build();
        soonToExpireEvaluationLicense = MockLicenses.builder().evaluation(true).expiryDate((Option<DateTime>)Option.some((Object)SOON_TO_EXPIRE_DATE)).build();
        inTheFarFutureExpireEvaluationLicense = MockLicenses.builder().evaluation(true).expiryDate((Option<DateTime>)Option.some((Object)IN_THE_FAR_FUTURE_EXPIRE_DATE)).build();
        userMismatchEvaluationLicense = MockLicenses.builder().evaluation(true).unlimitedUsers(false).build();
        oldMaintenanceExpiredNonEvaluationLicense = MockLicenses.builder().expiryDate((Option<DateTime>)Option.some((Object)OLD_EXPIRED_DATE)).build();
        newlyMaintenanceExpiredNonEvaluationLicense = MockLicenses.builder().expiryDate((Option<DateTime>)Option.some((Object)NEWLY_EXPIRED_DATE)).build();
        soonToMaintenanceExpireNonEvaluationLicense = MockLicenses.builder().expiryDate((Option<DateTime>)Option.some((Object)SOON_TO_EXPIRE_DATE)).build();
        inTheFarFutureMaintenanceExpireNonEvaluationLicense = MockLicenses.builder().expiryDate((Option<DateTime>)Option.some((Object)IN_THE_FAR_FUTURE_EXPIRE_DATE)).build();
        userMismatchNonEvaluationLicense = MockLicenses.builder().unlimitedUsers(false).build();
        editionMismatchNonEvaluationLicense = MockLicenses.builder().unlimitedUsers(false).build();
        soonToMaintenanceExpireNonEvaluationLicenseForLegacyPlugin = MockLicenses.builder().pluginKey(LEGACY_LICENSED_PLUGIN_KEY).expiryDate((Option<DateTime>)Option.some((Object)SOON_TO_EXPIRE_DATE)).build();
        inTheFarFutureMaintenanceExpireNonEvaluationDataCenterLicense = MockLicenses.builder().expiryDate((Option<DateTime>)Option.some((Object)IN_THE_FAR_FUTURE_EXPIRE_DATE)).dataCenter(true).build();
    }

    private static PluginLicenseMockBuilder builder() {
        return new PluginLicenseMockBuilder();
    }

    private static class PluginLicenseMockBuilder {
        final PluginLicense license;
        boolean eval = false;
        boolean unlimitedUsers = true;
        boolean subscription = false;
        boolean active = true;
        boolean autoRenewal = false;
        boolean dataCenter = false;
        String pluginKey = "my-plugin-key";
        Option<DateTime> expiryDate = Option.none();
        Option<DateTime> subscriptionEndDate = Option.none();

        PluginLicenseMockBuilder() {
            this.license = (PluginLicense)Mockito.mock(PluginLicense.class);
            Mockito.when((Object)this.license.getLicenseType()).thenReturn((Object)LicenseType.COMMERCIAL);
        }

        PluginLicense build() {
            Mockito.when((Object)this.license.getPluginKey()).thenReturn((Object)this.pluginKey);
            Mockito.when((Object)this.license.isEvaluation()).thenReturn((Object)this.eval);
            Mockito.when((Object)this.license.isUnlimitedEdition()).thenReturn((Object)this.unlimitedUsers);
            Mockito.when((Object)this.license.getEdition()).thenReturn((Object)(this.unlimitedUsers ? Option.none(Integer.class) : Option.some((Object)2)));
            if (!this.unlimitedUsers) {
                Mockito.when((Object)this.license.getError()).thenReturn((Object)Option.some((Object)LicenseError.USER_MISMATCH));
            }
            DateTime creationDate = new DateTime().minusDays(30);
            Mockito.when((Object)this.license.getCreationDate()).thenReturn((Object)creationDate);
            if (this.eval || this.dataCenter) {
                Mockito.when((Object)this.license.getExpiryDate()).thenReturn(this.expiryDate);
                Mockito.when((Object)this.license.getMaintenanceExpiryDate()).thenReturn(this.expiryDate);
            } else {
                Mockito.when((Object)this.license.getMaintenanceExpiryDate()).thenReturn(this.expiryDate);
                Mockito.when((Object)this.license.getExpiryDate()).thenReturn((Object)Option.none(DateTime.class));
            }
            if (this.expiryDate.isDefined() && (this.eval || this.dataCenter)) {
                Mockito.when((Object)this.license.getTimeBeforeExpiry()).thenReturn((Object)Option.some((Object)new Period((ReadableInstant)new DateTime(), (ReadableInstant)this.expiryDate.get())));
                if (((DateTime)this.expiryDate.get()).isBeforeNow()) {
                    if (this.license.getError() == null || !this.license.getError().isDefined()) {
                        Mockito.when((Object)this.license.getError()).thenReturn((Object)Option.some((Object)LicenseError.EXPIRED));
                        Mockito.when((Object)this.license.isMaintenanceExpired()).thenReturn((Object)true);
                    }
                } else {
                    Mockito.when((Object)this.license.getError()).thenReturn((Object)Option.none(LicenseError.class));
                }
            } else {
                Mockito.when((Object)this.license.getTimeBeforeExpiry()).thenReturn((Object)Option.none(Period.class));
                if (this.license.getError() == null || !this.license.getError().isDefined()) {
                    Mockito.when((Object)this.license.getError()).thenReturn((Object)Option.none(LicenseError.class));
                }
                if (this.expiryDate.isDefined() && ((DateTime)this.expiryDate.get()).isBeforeNow()) {
                    Mockito.when((Object)this.license.isMaintenanceExpired()).thenReturn((Object)true);
                }
            }
            Mockito.when((Object)this.license.isActive()).thenReturn((Object)this.active);
            Mockito.when((Object)this.license.isSubscription()).thenReturn((Object)this.subscription);
            Mockito.when((Object)this.license.getSubscriptionEndDate()).thenReturn(this.subscriptionEndDate);
            Mockito.when((Object)this.license.isAutoRenewal()).thenReturn((Object)this.autoRenewal);
            Mockito.when((Object)this.license.isDataCenter()).thenReturn((Object)this.dataCenter);
            return this.license;
        }

        PluginLicenseMockBuilder evaluation(boolean eval) {
            this.eval = eval;
            return this;
        }

        PluginLicenseMockBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        PluginLicenseMockBuilder pluginKey(String pluginKey) {
            this.pluginKey = pluginKey;
            return this;
        }

        PluginLicenseMockBuilder subscription(boolean subscription, DateTime subscriptionEndDate) {
            this.subscription = subscription;
            if (subscription) {
                this.subscriptionEndDate = Option.some((Object)subscriptionEndDate);
            }
            return this;
        }

        PluginLicenseMockBuilder autoRenewal(boolean autoRenewal) {
            this.autoRenewal = autoRenewal;
            return this;
        }

        PluginLicenseMockBuilder unlimitedUsers(boolean unlimitedUsers) {
            this.unlimitedUsers = unlimitedUsers;
            return this;
        }

        PluginLicenseMockBuilder expiryDate(Option<DateTime> expiryDate) {
            this.expiryDate = expiryDate;
            return this;
        }

        PluginLicenseMockBuilder dataCenter(boolean dataCenter) {
            this.dataCenter = dataCenter;
            return this;
        }
    }
}

