/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.jira;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.upm.license.role.jira.GlobalPermissionUserCountCache;
import com.atlassian.util.concurrent.NotNull;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class GlobalPermissionUserCountCacheImpl
implements GlobalPermissionUserCountCache {
    private final GlobalPermissionManager globalPermissionManager;
    private final Cache<GlobalPermissionKey, Integer> permissionCountCache;

    public GlobalPermissionUserCountCacheImpl(GlobalPermissionManager globalPermissionManager, CrowdService crowdService, CacheManager cacheManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionCountCache = cacheManager.getCache("com.atlassian.upm.license.role.jira.GlobalPermissionUserCountCache", (CacheLoader)new GlobalPermissionUserCountCacheLoader(crowdService), new CacheSettingsBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build());
    }

    @Override
    public void resetAll() {
        this.permissionCountCache.removeAll();
    }

    @Override
    public void reset(GlobalPermissionKey globalPermissionKey) {
        this.permissionCountCache.remove((Object)globalPermissionKey);
    }

    @Override
    public int getUserCount(GlobalPermissionKey globalPermissionKey) {
        return (Integer)this.permissionCountCache.get((Object)globalPermissionKey);
    }

    private class GlobalPermissionUserCountCacheLoader
    implements CacheLoader<GlobalPermissionKey, Integer> {
        private final CrowdService crowdService;

        public GlobalPermissionUserCountCacheLoader(CrowdService crowdService) {
            this.crowdService = crowdService;
        }

        private Iterable<User> getGroupMembers(String groupName) {
            MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
            return this.crowdService.search((Query)membershipQuery);
        }

        public Integer load(@NotNull GlobalPermissionKey permissionKey) {
            Collection groupsWithUsePermission = GlobalPermissionUserCountCacheImpl.this.globalPermissionManager.getGroupNamesWithPermission(permissionKey);
            HashSet<User> allUsers = new HashSet<User>();
            for (String groupName : groupsWithUsePermission) {
                Iterable<User> users = this.getGroupMembers(groupName);
                for (User user : users) {
                    if (!user.isActive() || !this.hasUsePermission(user)) continue;
                    allUsers.add(user);
                }
            }
            return allUsers.size();
        }

        private boolean hasUsePermission(User user) {
            for (String permission : GlobalPermissionType.getUsePermissions()) {
                if (!GlobalPermissionUserCountCacheImpl.this.globalPermissionManager.hasPermission(GlobalPermissionKey.of((String)permission), ApplicationUsers.from((User)user))) continue;
                return true;
            }
            return false;
        }
    }
}

